% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_greta_deps.R
\name{greta_deps_spec}
\alias{greta_deps_spec}
\title{Specify python dependencies for greta}
\usage{
greta_deps_spec(
  tf_version = "2.15.0",
  tfp_version = "0.23.0",
  python_version = "3.10"
)
}
\arguments{
\item{tf_version}{Character. Tensorflow (TF) version in format
major.minor.patch. Default is "2.15.0".}

\item{tfp_version}{Character.Tensorflow probability (TFP) version
major.minor.patch. Default is "0.23.0".}

\item{python_version}{Character. Python version in format major.minor.patch.
Default is "3.10".}
}
\value{
data frame of valid dependencies
}
\description{
A helper function for specifying versions of Tensorflow (TF), Tensorflow
Probability (TFP), and Python. Defaulting to 2.15.0, 0.23.0, and 3.10,
respectively. You can specify the version that you want to install, but
it will check if these are compatible. That is, if you specify versions of
TF/TFP/Python which do not work with each other, it will error and give
a suggested version to install. It does this by using a dataset,
\code{greta_deps_tf_tfp}, to check if the versions of TF, TFP, and Python
specified are compatible on your operating system. You can inspect
this  dataset with \code{View(greta_deps_tf_tfp)}.
}
\examples{
greta_deps_spec()
greta_deps_spec(tf_version = "2.15.0")
greta_deps_spec(tf_version = "2.15.0", tfp_version = "0.23.0")
greta_deps_spec(tf_version = "2.15.0", python_version = "3.10")
greta_deps_spec(
  tf_version = "2.15.0",
  tfp_version = "0.23.0",
  python_version = "3.10"
  )
# this will fail
\dontrun{
greta_deps_spec(
  tf_version = "2.11.0",
  tfp_version = "0.23.0",
  python_version = "3.10"
  )
  }
}
