% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpi_inflator.R
\name{cpi_inflator}
\alias{cpi_inflator}
\title{CPI inflator}
\usage{
cpi_inflator(from_nominal_price = 1, from_fy = NULL, to_fy = NULL,
  adjustment = c("seasonal", "none", "trimmed.mean"),
  useABSConnection = FALSE, allow.projection = TRUE,
  accelerate.above = 100000L)
}
\arguments{
\item{from_nominal_price}{(numeric) the price (or vector of prices) to be inflated}

\item{from_fy, to_fy}{(character) a character vector with each element in the form "2012-13" representing the financial years between which the CPI inflator is desired.

If both \code{from_fy} and \code{to_fy} are \code{NULL} (the default), \code{from_fy} is set to the previous financial year and \code{to_fy} to the current financial year, with a warning. Setting only one is an error.}

\item{adjustment}{What CPI index to use ("none" = raw series, "seasonal", or "trimmed" [mean]).}

\item{useABSConnection}{Should the function connect with ABS.Stat via an SDMX connection? If \code{FALSE} (the default), a pre-prepared index table is used. This is much faster and more reliable (in terms of errors), though of course relies on the package maintainer to keep the tables up-to-date. 

If the SDMX connection fails, a message is emitted (not a warning) and
the function contines as if \code{useABSConnection = FALSE}.

The internal data was updated on 2019-05-02 to 2019-Q1. 
If using \code{useABSConnection = TRUE}, ensure you have \code{rsdmx (>= 0.5-10)} up-to-date.}

\item{allow.projection}{Should projections beyond the ABS's data be allowed?}

\item{accelerate.above}{An integer setting the threshold for 'acceleration'. 
When the maximum length of the arguments exceeds this value, calculate each unique value individually 
then combine. Set to 100,000 as a rule of thumb beyond which calculation speeds benefit
dramatically. Can be set to \code{Inf} to disable acceleration.}
}
\value{
The value of \code{from_nominal_price} in real (\code{to_fy}) dollars.
}
\description{
CPI inflator
}
\examples{
cpi_inflator(100, from_fy = "2005-06", to_fy = "2014-15")
}
