% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pension_supplement.R
\name{pension_supplement}
\alias{pension_supplement}
\title{Pension Supplement}
\usage{
pension_supplement(has_partner = FALSE, age = 70, n_dependants = 0,
  parenting_payment = FALSE, Date = NULL, fy.year = NULL,
  qualifying_payment = "age_pension", per = c("year", "fortnight",
  "quarter"), overseas_absence = FALSE, seperated_couple = FALSE)
}
\arguments{
\item{has_partner}{Does the individual have a partner?}

\item{age}{The individual's age. Default is 70 years.}

\item{n_dependants}{How many dependant children does the individual have?}

\item{parenting_payment}{Is the individual receiving parenting payment?}

\item{Date}{Date. Default is "2016/03/01" if fy.year is not present.}

\item{fy.year}{Financial year. Default is "2015-16" if Date is not present.}

\item{qualifying_payment}{What is the payment that the supplement is being applied to?}

\item{per}{How often the payment will be made. Default is to return the annual
payment, with a message.}

\item{overseas_absence}{Will the individual be living outside of Australia 
for more than 6 weeks of the upcoming year?}

\item{seperated_couple}{Is the individual part of an illness separated couple,
respite care couple, or partner imprisoned?}
}
\description{
The Pension Supplement gets added to the max rate of payment before income reduction tests are applied. Note that if the individual is part of a couple, the rate indicates the payment amount per person, not for the couple.
Can be claimed by those receiving Age Pension, Carer Payment, Wife Pension, Widow B Pension, Bereavement Allowance, or Disability Support Pension (except if under 21 and have no children).
Can also be claimed if over age pension age and are receiving ABSTUDY, Austudy, Parenting Payment, Partner Allowance, Special Benefit, or Widow Allowance.
Can still claim the basic amount if single, under age pension age, and receive the Parenting Payment.
}
\author{
Matthew Katzen
}
