% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmixmorm.R
\name{rmixnorm_ts}
\alias{rmixnorm_ts}
\title{Simulate AR type random variables from mixture of normal}
\usage{
rmixnorm_ts(n, means.ar.par.list, sigmas.list, weights, yinit = 0)
}
\arguments{
\item{n}{number of samples.}

\item{means.ar.par.list}{parameters in AR(p) within each mixing compoment.}

\item{sigmas.list}{variance list.}

\item{weights}{weight in each list.}

\item{yinit}{initial values.}
}
\value{
vector of n follows a mixture distribution.
}
\description{
This function simulates random samples from a finite mixture of Gaussian distribution
    where the mean from each components are AR(p) process.
}
\examples{
n = 1000
means.ar.par.list = list(c(0, 0.8), c(0, 0.6, 0.3))
require("fGarch")
sigmas.spec <- list(garchSpec(model = list(alpha = c(0.05, 0.06)), cond.dist = "norm"),
                    garchSpec(model = list(alpha = c(0.05, 0.05)), cond.dist = "norm"))
sigmas.list <- lapply(lapply(sigmas.spec, garchSim, extended = TRUE, n = n),
function(x) x$sigma)
weights <- c(0.8, 0.2)
y = rmixnorm_ts(n = n, means.ar.par.list = means.ar.par.list, sigmas.list = sigmas.list,
                weights = weights)
plot(y)
}
\references{
Li 2010 JSPI.
}
\author{
Feng Li, Central University of Finance and Economics.
}
