% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int_period.R
\name{as_int_period}
\alias{as_int_period}
\alias{as_int_period.default}
\title{Convert an object to grates_int_period object}
\usage{
as_int_period(x, ...)

\method{as_int_period}{default}(x, n = 1L, origin = 0L, ...)
}
\arguments{
\item{x}{An object to convert.}

\item{...}{Not currently used.}

\item{n}{An integer indicating the (fixed) number of days used for
grouping; defaults to 1.}

\item{origin}{Day on which the grouping begins (default 0).}
}
\value{
A \code{grates_int_period} object.
}
\description{
\itemize{
\item Date, POSIXct, and POSIXlt are converted, with the timezone respected,
using \code{\link[clock:as_date]{clock::as_date()}}.
\item Character input is parsed using \code{\link[clock:date_parse]{clock::date_parse()}}.
}
}
\note{
Internally \code{grates_int_period} objects are stored as the number of days
to the earliest day in the specified grouping.
}
\examples{
as_int_period(0:10, n = 2)

}
