% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commonlink.R
\name{make_commonlink}
\alias{make_commonlink}
\alias{make_commonlink_adjmat}
\alias{make_commonlink_graph}
\title{Generate Common Link Matrix}
\usage{
make_commonlink_adjmat(adj_mat)

make_commonlink_graph(graph, directed = FALSE)
}
\arguments{
\item{adj_mat}{precomputed adjacency matrix.}

\item{graph}{An \code{\link[igraph]{igraph}} object. May be directed or weighted.}

\item{directed}{logical. Whether directed information is passed to the adjacency matrix.}
}
\value{
An integer matrix of number of links shared between nodes
}
\description{
Compute the common link matrix of a (directed) \code{\link[igraph]{igraph}} structure, preserving node / column / row names (and direction).
}
\examples{

library("igraph")
graph_test_edges <- rbind(c("A", "B"), c("B", "C"), c("B", "D"))
graph_test <- graph.edgelist(graph_test_edges, directed = TRUE)
adjacency_matrix <- make_adjmatrix_graph(graph_test)
common_link_matrix <- make_commonlink_adjmat(adjacency_matrix)

}
\keyword{graph}
\keyword{igraph}
\keyword{neighbourhood}
\keyword{network}
