% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_danube.R
\name{plotDanube}
\alias{plotDanube}
\alias{plotDanubeIGraph}
\title{Plot Danube River Flow Data}
\usage{
plotDanube(
  stationIndices = NULL,
  graph = NULL,
  directed = NULL,
  plotStations = TRUE,
  plotConnections = TRUE,
  labelStations = FALSE,
  returnGGPlot = FALSE,
  useStationVolume = FALSE,
  useConnectionVolume = FALSE,
  mapCountries = c("Germany"),
  vertexColors = NULL,
  vertexShapes = NULL,
  edgeColors = NULL,
  xyRatio = NULL,
  clipMap = 1.2,
  useLatex = FALSE,
  edgeAlpha = 0.2
)

plotDanubeIGraph(
  stationIndices = NULL,
  graph = NULL,
  directed = NULL,
  labelStations = TRUE,
  vertexColors = NULL,
  vertexShapes = NULL,
  edgeColors = NULL,
  ...
)
}
\arguments{
\item{stationIndices}{Logical or numerical vector, indicating the stations to be plotted.}

\item{graph}{An \code{\link[igraph:make_graph]{igraph::graph}} object or \code{NULL} to use the flow graph.}

\item{directed}{Logical. Whether to consider the flow graph as directed.}

\item{plotStations}{Logical. Whether to plot the stations.}

\item{plotConnections}{Logical. Whether to plot the connections.}

\item{labelStations}{Logical. Whether to label stations.}

\item{returnGGPlot}{If \code{TRUE}, a \code{\link[ggplot2:ggplot]{ggplot2::ggplot}} object is returned and not plotted immediately.}

\item{useStationVolume}{Logical. Whether to indicate flow volume at a station by circle size.}

\item{useConnectionVolume}{Logical. Whether to indicate flow volume on a connection by line width.}

\item{mapCountries}{Which country borders to show using \code{ggplot2::map_data('world', mapCountries)}.}

\item{vertexColors}{Vector with color information for vertices.}

\item{vertexShapes}{Vector with shape information for vertices.}

\item{edgeColors}{Vector with color information for edges.}

\item{xyRatio}{Approximate X-Y-ratio (w.r.t. distance on the ground) of the area shown in the plot.}

\item{clipMap}{Logical or numeric scalar. Whether to ignore the map image when determining the axis limits of the plot.
If it is a positive scalar, the plot limits are extended by that factor.}

\item{useLatex}{Whether to format numbers etc. as latex code (useful when plotting to tikz).}

\item{edgeAlpha}{Numeric scalar between 0 and 1. The alpha value to be used when plotting edges/connections.}

\item{...}{Passed through to \code{\link[igraph:plot.igraph]{igraph::plot.igraph}}.}
}
\description{
Plotting function to visualize the river flow data from the \code{\link{danube}} dataset.
Requires \code{ggplot2} to be installed.
}
\details{
The values of \code{vertexColors}, \code{vertexShapes}, and \code{edgeColors} are interpreted differently
by \code{\link[ggplot2:geom_point]{ggplot2::geom_point}}/\code{\link[ggplot2:geom_segment]{ggplot2::geom_segment}} and \code{\link[igraph:plot.igraph]{igraph::plot.igraph()}}.

\code{plotDanube} uses a combination of \code{ggplot2} functions to plot the graph.

\code{plotDanubeIGraph} uses \code{\link[igraph:plot.igraph]{igraph::plot.igraph}} to plot the graph.
}
\examples{
# Basic plot
graphicalExtremes::plotDanube()

# Plot flow volumes
graphicalExtremes::plotDanube(
    clipMap = 1.2,
    useConnectionVolume = TRUE,
    useStationVolume = TRUE
)

# Plot other graph structures
nStations <- nrow(graphicalExtremes::danube$info)
g <- igraph::erdos.renyi.game(nStations, nStations, 'gnm')
graphicalExtremes::plotDanube(
    clipMap = 1.2,
    graph = g
)

}
\seealso{
\code{\link{plotFlights}}

Other danubeData: 
\code{\link{danube}},
\code{\link{getDanubeFlowGraph}()}
}
\concept{danubeData}
