% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_examples.R
\name{generate_random_spd_matrix}
\alias{generate_random_spd_matrix}
\title{Generate a random symmetric positive definite matrix}
\usage{
generate_random_spd_matrix(d, bMin = -10, bMax = 10, ...)
}
\arguments{
\item{d}{Number of rows/columns}

\item{bMin}{Minimum value of entries in \code{B}}

\item{bMax}{Maximum value of entries in \code{B}}

\item{...}{Ignored, only allowed for compatibility}
}
\description{
Generates a random \dxd symmetric positive definite matrix.
This is done by generating a random \dxd matrix \code{B},
then computing \code{B \%*\% t(B)},
and then normalizing the matrix to approximately single digit entries.
}
\seealso{
Other example generation functions:
\code{\link{generate_random_Gamma}()},
\code{\link{generate_random_chordal_graph}()},
\code{\link{generate_random_graphical_Gamma}()},
\code{\link{generate_random_integer_Gamma}()},
\code{\link{generate_random_model}()}
}
\concept{exampleGenerations}
