% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation_functions.R
\name{complete_Gamma}
\alias{complete_Gamma}
\title{Completion of Gamma matrix on block graphs}
\usage{
complete_Gamma(Gamma, graph)
}
\arguments{
\item{Gamma}{Numeric \eqn{d \times d}{d x d} variogram matrix
with entries only specified within the cliques of the \code{graph}. Alternatively, can be a
vector containing the \code{Gamma} entries for each edge in the same order as in the
\code{graph} object.}

\item{graph}{Graph object from \code{igraph} package.
The \code{graph} must be an undirected block graph, i.e., a decomposable, connected
graph with singleton separator sets.}
}
\value{
Completed \eqn{d \times d}{d x d} \code{Gamma} matrix.
s
}
\description{
Given a block \code{graph} and \code{Gamma} matrix with entries only specified on
edges within the cliques of the \code{graph}, it returns the full \code{Gamma} matrix
implied by the conditional independencies.
}
\details{
For a block graph it suffices to specify the dependence parameters of the Huesler--Reiss
distribution within the cliques of the \code{graph}, the remaining entries are implied
by the conditional independence properties. For details see \insertCite{eng2019;textual}{graphicalExtremes}.
}
\examples{
## Complete a 4-dimensional HR distribution

my_graph <- igraph::graph_from_adjacency_matrix(rbind(
c(0, 1, 0, 0),
c(1, 0, 1, 1),
c(0, 1, 0, 1),
c(0, 1, 1, 0)),
mode = "undirected")

Gamma <- rbind(
c(0, .5, NA, NA),
c(.5, 0, 1, 1.5),
c(NA, 1, 0, .8),
c(NA, 1.5, .8, 0))

complete_Gamma(Gamma, my_graph)

## Alternative

Gamma_vec <- c(.5, 1, 1.5, .8)
complete_Gamma(Gamma_vec, my_graph)

}
\references{
\insertAllCited{}
}
