% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphical_evidence_G_Wishart.R
\name{graphical_evidence_G_Wishart}
\alias{graphical_evidence_G_Wishart}
\title{Compute Marginal Likelihood using Graphical Evidence under G Wishart}
\usage{
graphical_evidence_G_Wishart(
  xx,
  burnin,
  nmc,
  alpha,
  V,
  G,
  print_progress = FALSE
)
}
\arguments{
\item{xx}{The input data specified by a user for which the marginal 
likelihood is to be calculated. This should be input as a matrix like object
with each individual sample of xx representing one row}

\item{burnin}{The number of iterations the MCMC sampler should iterate 
through and discard before beginning to save results}

\item{nmc}{The number of samples that the MCMC sampler should use to estimate
marginal likelihood}

\item{alpha}{A number specifying alpha for G-Wishart prior}

\item{V}{The scale matrix of G-Wishart prior}

\item{G}{The adjacency matrix of G-Wishart prior}

\item{print_progress}{A boolean which indicates whether progress should be 
displayed on the console as each row of the telescoping sum is computed}
}
\value{
An estimate for the marginal likelihood under G-Wishart prior with
the specified parameters
}
\description{
Computes the marginal likelihood of input data xx under G-Wishart prior using
graphical evidence.
}
\examples{
# Compute the marginal likelihood of xx for G-Wishart prior using 
# 2,000 burnin and 10,000 sampled values at each call to the MCMC sampler
g_params <- gen_params_evidence('G_Wishart')
marginal_results <- graphical_evidence_G_Wishart(
  g_params$x_mat, 2e3, 1e4, 2, g_params$scale_mat, g_params$g_mat
)
}
