% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamize.R
\name{dynamise}
\alias{dynamise}
\title{Make a dynamic graph}
\usage{
dynamise(data, tweets, source, start.stamp, end.stamp = NULL,
  str.length = NULL, write = FALSE, format = "graphml",
  file.dir = getwd(), file.name = "graphTweets", open = FALSE)
}
\arguments{
\item{data}{\code{data.frame} of tweets, typically returned by 
\code{\link[twitteR]{searchTwitter}}, required.}

\item{tweets}{Column name of tweets within \code{data}, must be a 
\code{character} string, required.}

\item{source}{User names or ID column of \code{tweets} author, must be a 
\code{character} string, required.}

\item{start.stamp}{time.stamp to dynamise, typically a date or time, but may 
also be an interger or a factor, cannot be a character.}

\item{end.stamp}{The end of the time stamp, or when edges are to leave the 
graph, defaults to \code{NULL} (edges never disappear). See details.}

\item{str.length}{Defaults to \code{NULL}. Shorten length of @tags 
(see details in \code{\link{getEdges}}), to a maximum number of characters, 
optional.}

\item{write}{if \code{TRUE} saves graph as file.}

\item{format}{if \code{write = TRUE} set format of file, defaults to 
\code{graphml} (see details for valid formats).}

\item{file.dir}{if \code{write = TRUE} directory where to save the file, 
defaults to working directory.}

\item{file.name}{if \code{write = TRUE} name of file}

\item{open}{if \code{write = TRUE}, \code{open = TRUE} opens file in 
\href{Gephi}{https://gephi.org/}.}
}
\description{
Create a dynamic graph from tweets and, optionally, open it in 
\href{https://gephi.org/}{Gephi}
}
\details{
\code{end.stamp}: When the edges are to disappear, consider lifetime 
of a tweet, by default edges stay.

Valid values for \code{format}:
\itemize{
\item \code{edgelist}
\item \code{pajek}
\item \code{ncol}
\item \code{lgl}
\item \code{graphml} (default)
\item \code{dimacs}
\item \code{gml}
\item \code{dot}
\item \code{leda}
}
}
\examples{
\dontrun{
# load twitteR package to get data
library(twitteR)

# replace with your details
setup_twitter_oauth(consumer_key, consumer_secret, access_token, 
                    access_secret)
                    
# fetch tweets on rstats
tweets <- searchTwitter("rstats", n = 200)
tweets <- twListToDF(tweets)

# create dynamic graph
dyn <- dynamise(tweets, tweets = "text", source = "screenName", 
                time.stamp = "created")
                
# create dynamic graph and open in Gephi
dyn <- dynamise(tweets, tweets = "text", source = "screenName", 
                time.stamp = "created", write = TRUE, open = TRUE)
}

}
\author{
John Coene \email{jcoenep@gmail.com}
}

