% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint_PAF.R
\name{print.SAF_summary}
\alias{print.SAF_summary}
\title{Print out a SAF_summary object}
\usage{
\method{print}{SAF_summary}(x, ...)
}
\arguments{
\item{x}{A SAF_summary object.  This is a special dataframe that is created by running the function average_PAF.}

\item{...}{Other arguments to be passed to print}
}
\value{
No return value.  Prints the SAF_summary object to the console.
}
\description{
Print out a SAF_summary object
}
\examples{
library(splines)
library(survival)
library(parallel)
options(boot.parallel="snow")
options(boot.ncpus=2)
# The above could be set to the number of available cores on the machine
#  Simulated data on occupational and environmental exposure to chronic cough from Eide, 1995
# First specify the causal graph, in terms of the parents of each node.  Then put into a list
parent_urban.rural <- c()
parent_smoking.category <- c("urban.rural")
parent_occupational.exposure <- c("urban.rural")
parent_y <- c("urban.rural","smoking.category","occupational.exposure")
parent_list <- list(parent_urban.rural, parent_smoking.category,
parent_occupational.exposure, parent_y)
node_vec <- c("urban.rural","smoking.category","occupational.exposure", "y")
model_list=automatic_fit(data=Hordaland_data, parent_list=parent_list,
 node_vec=node_vec, prev=.09)
# model_list$data objects have fitting weights
# included in data frame
# Including weight column in data
# necessary if Bootstrapping CIs
out <- average_paf(data=model_list[[length(model_list)]]$data,
model_list=model_list,
parent_list=parent_list, node_vec=node_vec, prev=.09, nperm=10,
riskfactor_vec = c("urban.rural","occupational.exposure"),ci=FALSE)
print(out)
}
