% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradDescent.Methods.R
\name{gradientDescent}
\alias{gradientDescent}
\title{Gradient Descent learn}
\usage{
gradientDescent(inputData, outputData, list)
}
\arguments{
\item{inputData}{a matrix of input data that created inside gradDescent.learn
function.}

\item{outputData}{a matrix of output data that created inside gradDescent.learn
function.}

\item{list}{a list of parameter that customize the learn.
       
\itemize{
\item \code{rowLength}: a integer of data length (row).
\item \code{theta}: a matrix of float number of current model value.
\item \code{alpha} : a float value for learning rate.
\item \code{momentum} : a float value to give a constant speed to learning process..
\item \code{smooth} : a float value to handle zero division issue in certain learning method.
\item \code{stochastic} : a boolean value to enable stochastic, which mean to select one random
                   value in data train, instead process all data train. 
\item \code{accelerate} : a boolean value to enable accelerate in the learning with momentum.
\item \code{maxIter} : Adaptive Moment Estimation method to calculate gradient.
}}
}
\value{
a matrix of theta
}
\description{
This is internal function of learning stage that implement batch Gradient 
Descent method to create model.
}
\references{
A. Cotter, O. Shamir, N. Srebro, K. Sridharan. (2011). Better Mini-Batch Algorithm via
    Accelerated Gradien Methods. NIPS.
L. Buttou. (2016). Large-Scale Machine Learning with Stochastic Gradient Descent.
    COMPSTAT'2010 (pp.17-186). NEC Labs America, Princeton NJ 088542, USA.
N. Qian. (1999). On the momentum term in gradient descent learning algorithms.
    Neural networks: the official journal of the International Neural Network Society,
    145-151.
Y. Nesterov. (1983). A method for unconstrained convex minimization problem with the rate of
    convergence O (1/k2). Soviet Mathematic Doklady 27 (2), 543-547.
}

