% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/methods-gpuVector.R,
%   R/methods-vclMatrix.R, R/methods-vclVector.R, R/methods.R
\docType{methods}
\name{deepcopy}
\alias{deepcopy}
\alias{deepcopy,gpuVector-method}
\alias{deepcopy,vclMatrix-method}
\alias{deepcopy,vclVector-method}
\alias{deepcopy,gpuMatrix-method}
\title{Copy a "gpuR" object}
\usage{
deepcopy(object, ...)

\S4method{deepcopy}{gpuVector}(object)

\S4method{deepcopy}{vclMatrix}(object, source = FALSE)

\S4method{deepcopy}{vclVector}(object)

\S4method{deepcopy}{gpuMatrix}(object)
}
\arguments{
\item{object}{A gpuR object}

\item{...}{Additional arguments}

\item{source}{A boolean indicating if source matrix should be copied (only
relevant for 'block' and 'slice' objects).}
}
\value{
A gpuR object

A deep copy of the input \code{gpuVector} object.

A deep copy of the input \code{vclMatrix} object.

A deep copy of the input \code{vclVector} object.

A deep copy of the input \code{gpuMatrix} object.
}
\description{
This is needed to make a duplicate of a gpuR object
}
\details{
This is needed to make a duplicate of a gpuR object 
(i.e. \code{\link{gpuMatrix}}, \code{\link{gpuVector}}, 
\code{\link{vclMatrix}}, \code{\link{vclVector}} because
the traditional syntax would only copy the pointer of the object.
}
\seealso{
\code{\link{block}}
}
\author{
Charles Determan Jr.
}
