% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/methods-gpuMatrix.R, R/methods-gpuVector.R, R/methods-vclMatrix.R, R/methods-vclVector.R
\docType{methods}
\name{deepcopy}
\alias{deepcopy}
\alias{deepcopy,gpuMatrix-method}
\alias{deepcopy,gpuVector-method}
\alias{deepcopy,vclMatrix-method}
\alias{deepcopy,vclVector-method}
\title{Copy a "gpuR" object}
\usage{
deepcopy(object)

\S4method{deepcopy}{gpuMatrix}(object)

\S4method{deepcopy}{gpuVector}(object)

\S4method{deepcopy}{vclMatrix}(object)

\S4method{deepcopy}{vclVector}(object)
}
\arguments{
\item{object}{A gpuR object}
}
\value{
A gpuR object
}
\description{
This is needed to make a duplicate of a gpuR object
}
\details{
This is needed to make a duplicate of a gpuR object 
(i.e. \code{\link{gpuMatrix}}, \code{\link{gpuVector}}, 
\code{\link{vclMatrix}}, \code{\link{vclVector}} because
the traditional syntax would only copy the pointer of the object.
}
\author{
Charles Determan Jr.
}
\seealso{
\code{\link{block}}
}

