% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{balanced}
\alias{balanced}
\title{Balanced operator}
\usage{
balanced(f, ...)
}
\arguments{
\item{f}{A function.}

\item{...}{Deprecated. Additional arguments to \code{f} that should \emph{not} be
balanced.}
}
\value{
A function like \code{f} with a new argument \code{na.rm}. If \code{na.rm = TRUE} then
\code{\link[=complete.cases]{complete.cases()}} is used to remove missing values across all inputs
prior to calling \code{f}.
}
\description{
Makes a function balance the removal of \code{NA}s across multiple input vectors.
}
\examples{
p1 <- price6[[3]]
p0 <- price6[[2]]
q1 <- quantity6[[3]]
q0 <- quantity6[[2]]

# Balance missing values for a Fisher index

fisher <- balanced(fisher_index)
fisher(p1, p0, q1, replace(q0, 3, NA), na.rm = TRUE)
fisher_index(p1[-3], p0[-3], q1[-3], q0[-3])

# Operators can be combined, but some care may be needed

x <- 1:6
w <- c(1:5, NA)

f <- factor(rep(letters[1:2], each = 3))

grouped(\(x, w) balanced(fisher_mean)(x, w, na.rm = TRUE))(x, w, group = f)
balanced(grouped(fisher_mean))(x, w, group = f, na.rm = TRUE)

}
\seealso{
Other operators: 
\code{\link{grouped}()},
\code{\link{quantity_index}()}
}
\concept{operators}
