% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeGPHMM.R
\name{computegphmm}
\alias{computegphmm}
\title{Compute GPHMM log probability.}
\usage{
computegphmm(read, ref, parameters = initializeGphmm(), qv = 20,
  output = "long")
}
\arguments{
\item{read}{- chr str.}

\item{ref}{- chr str.}

\item{parameters}{- list of GPHMM parameters, can be created by initializeGphmm().}

\item{qv}{- float, quality value, default is 20.}

\item{output}{- if 'long', output is a list with path, read, ref and log GPHMM proba, else output is just the log GPHMM proba.}
}
\description{
\code{computegphmm} returns GPHMM log probability for a read and a reference sequence.
}
\examples{
computegphmm('TAGC', 'AAG')
computegphmm('TAGC', 'AAG', qv = 30)
}
