% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPModel.R
\name{get_coef.GPModel}
\alias{get_coef.GPModel}
\title{Get (estimated) linear regression coefficients}
\usage{
\method{get_coef}{GPModel}(gp_model)
}
\arguments{
\item{gp_model}{A \code{GPModel}}
}
\value{
A \code{GPModel}
}
\description{
Get (estimated) linear regression coefficients and standard deviations (if std_dev=TRUE was set in \code{fit})
}
\examples{
\donttest{
data(GPBoost_data, package = "gpboost")
X1 <- cbind(rep(1,dim(X)[1]),X) # Add intercept column
gp_model <- fitGPModel(group_data = group_data[,1], y = y, X = X1, likelihood="gaussian")
get_coef(gp_model)
}
}
\author{
Fabio Sigrist
}
