% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10-grafos-TSP.R
\encoding{UTF-8}
\name{build_tour_nn_best}
\alias{build_tour_nn_best}
\title{Build a tour for a TSP using the best nearest neighbor
heuristic}
\usage{
build_tour_nn_best(d, n)
}
\arguments{
\item{d}{Distance matrix of the TSP.}

\item{n}{Number of vertices of the TSP complete graph.}
}
\value{
A list with four components: $tour contains a permutation
of the 1:n sequence representing the tour constructed by the
algorithm, $distance contains the value of the distance
covered by the tour, $start contains the better starting
vertex found, and $Lall contains the distances found by
starting from each vertex.
}
\description{
Nearest neighbor heuristic tour-building algorithm for the
Traveling Salesperson Problem - Better starting point
}
\details{
It applies the nearest neighbor heuristic with all possible
starting vertices, retaining the best tour returned by
\link{build_tour_nn}.
}
\examples{
## Regular example with obvious solution (minimum distance 48)
m <- 10   # Generate some points in the plane
z <- cbind(c(rep(0,m), rep(2,m), rep(5,m), rep(7,m)), rep(seq(0,m-1),4))
n <- nrow(z)
d <- compute_distance_matrix(z)
b <- build_tour_nn_best(d, n)
b$distance    # Distance 48.6055
b$start       # Vertex 12
plot_tour(z,b)

## Random points
set.seed(1)
n <- 25
z <- cbind(runif(n,min=1,max=10),runif(n,min=1,max=10))
d <- compute_distance_matrix(z)
b <- build_tour_nn_best(d, n)
b$distance    # Distance 36.075
b$start       # Vertex 13
plot_tour(z,b)

}
\seealso{
\link{build_tour_nn} nearest neighbor heuristic with a single
starting point, \link{compute_tour_distance} computes tour
distances, \link{compute_distance_matrix} computes a distance
matrix, \link{plot_tour} plots a tour.
}
\author{
Cesar Asensio
}
