% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate.R
\name{gl_translate}
\alias{gl_translate}
\title{Translate the language of text within a request}
\usage{
gl_translate(
  t_string,
  target = "en",
  format = c("text", "html"),
  source = "",
  model = c("nmt", "base")
)
}
\arguments{
\item{t_string}{Character vector of text to translate}

\item{target}{The target language code}

\item{format}{Whether the text is plain text or HTML}

\item{source}{Specify the language to translate from. Will detect it if left default}

\item{model}{Translation model to use}
}
\value{
A tibble of \code{translatedText}, \code{detectedSourceLanguage}, and \code{text} of length equal to the vector of text you passed in
}
\description{
Translate character vectors via the Google Translate API.
}
\details{
You can translate a vector of strings; if too many for one call, it will be
broken up into one API call per element.
The API charges per character translated, so splitting does not change cost but may take longer.

If translating HTML, set \code{format = "html"}.
Consider removing anything not needed to be translated first, such as JavaScript or CSS.

API limits: characters per day, characters per 100 seconds, and API requests per 100 seconds.
These can be configured in the API manager: \url{https://console.developers.google.com/apis/api/translate.googleapis.com/quotas}
}
\seealso{
\url{https://cloud.google.com/translate/docs/reference/translate}

Other translations: 
\code{\link{gl_translate_detect}()},
\code{\link{gl_translate_document}()},
\code{\link{gl_translate_languages}()}
}
\concept{translations}
