% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{gcs_signed_url}
\alias{gcs_signed_url}
\title{Create a signed URL}
\usage{
gcs_signed_url(meta_obj, expiration_ts = Sys.time() + 3600, verb = "GET",
  md5hash = NULL, includeContentType = FALSE)
}
\arguments{
\item{meta_obj}{A meta object from \link{gcs_get_object}}

\item{expiration_ts}{A timestamp of class \code{"POSIXct"} such as from \code{Sys.time()} or a numeric in seconds from Unix Epoch.  Default is 60 mins.}

\item{verb}{The URL verb of access e.g. \code{GET} or \code{PUT}. Default \code{GET}}

\item{md5hash}{An optional md5 digest value}

\item{includeContentType}{For getting the URL via browsers this should be set to \code{FALSE} (the default).  Otherwise, set to \code{TRUE} to include the content type of the object in the request needed.}
}
\description{
This creates a signed URL which you can share with others who may or may not have a Google account.
The object will be available until the specified timestamp.
}
\details{
Create a URL with a time-limited read and write to an object, regardless whether they have a Google account
}
\examples{

\dontrun{

obj <- gcs_get_object("your_file", meta = TRUE)

signed <- gcs_signed_url(obj)

temp <- tempfile()
on.exit(unlink(temp))

download.file(signed, destfile = temp)
file.exists(temp)

}

}
\seealso{
\url{https://cloud.google.com/storage/docs/access-control/signed-urls}

Other download functions: \code{\link{gcs_download_url}},
  \code{\link{gcs_parse_download}}
}
