% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy-run.R
\name{cr_deploy_run}
\alias{cr_deploy_run}
\alias{cr_deploy_html}
\alias{cr_deploy_plumber}
\title{Deploy to Cloud Run}
\usage{
cr_deploy_run(
  local,
  remote = basename(local),
  dockerfile = NULL,
  image_name = remote,
  tag = "$BUILD_ID",
  region = cr_region_get(),
  bucket = cr_bucket_get(),
  projectId = cr_project_get(),
  launch_browser = interactive(),
  timeout = 600L,
  kaniko_cache = TRUE,
  pre_steps = NULL,
  post_steps = NULL,
  ...
)

cr_deploy_html(
  html_folder,
  remote = basename(html_folder),
  image_name = remote,
  tag = "$BUILD_ID",
  region = cr_region_get(),
  bucket = cr_bucket_get(),
  projectId = cr_project_get(),
  launch_browser = interactive(),
  timeout = 600L,
  ...
)

cr_deploy_plumber(
  api,
  remote = basename(api),
  dockerfile = NULL,
  image_name = remote,
  tag = "$BUILD_ID",
  region = cr_region_get(),
  bucket = cr_bucket_get(),
  projectId = cr_project_get(),
  launch_browser = interactive(),
  timeout = 600L,
  ...
)
}
\arguments{
\item{local}{A folder containing the scripts and Dockerfile to deploy to Cloud Run}

\item{remote}{The folder on Google Cloud Storage, and the name of the service on Cloud Run}

\item{dockerfile}{An optional Dockerfile built to support the script.  Not needed if 'Dockerfile' exists in folder.  If supplied will be copied into deployment folder and called "Dockerfile"}

\item{image_name}{The gcr.io image name that will be deployed and/or built}

\item{tag}{The tag or tags to be attached to the pushed image - can use \code{Build} macros}

\item{region}{The Cloud Run endpoint set by CR_REGION env arg}

\item{bucket}{The Cloud Storage bucket that will hold the code}

\item{projectId}{The projectId where it all gets deployed to}

\item{launch_browser}{Whether to launch the logs URL in a browser once deployed}

\item{timeout}{Amount of time that this build should be allowed to run, to second}

\item{kaniko_cache}{If TRUE will use kaniko cache for Docker builds.}

\item{pre_steps}{Other \link{cr_buildstep} to run before the docker build}

\item{post_steps}{Other \link{cr_buildstep} to run after the docker build}

\item{...}{
  Arguments passed on to \code{\link[=cr_buildstep_run]{cr_buildstep_run}}
  \describe{
    \item{\code{name}}{Name for deployment on Cloud Run}
    \item{\code{image}}{The name of the image to create or use in deployment - \code{gcr.io}}
    \item{\code{allowUnauthenticated}}{TRUE if can be reached from public HTTP address. If FALSE will configure a service-email called \code{(name)-cloudrun-invoker@(project-id).iam.gserviceaccount.com}}
    \item{\code{concurrency}}{How many connections each container instance can serve. Can be up to 80.}
    \item{\code{port}}{Container port to receive requests at. Also sets the $PORT environment variable. Must be a number between 1 and 65535, inclusive. To unset this field, pass the special value "default".}
    \item{\code{max_instances}}{the desired maximum nuimber of container instances. "default" is 1000, you can get more if you requested a quota instance.  For Shiny instances on Cloud Run, this needs to be 1.}
    \item{\code{memory}}{The format for size is a fixed or floating point number followed by a unit: G, M, or K corresponding to gigabyte, megabyte, or kilobyte, respectively, or use the power-of-two equivalents: Gi, Mi, Ki corresponding to gibibyte, mebibyte or kibibyte respectively. The default is 256Mi}
    \item{\code{cpu}}{1 or 2 CPUs for your instance}
    \item{\code{env_vars}}{Environment arguments passed to the Cloud Run container at runtime.  Distinct from \code{env} that run at build time.}
    \item{\code{gcloud_args}}{a character string of arguments that can be sent to the gcloud command not covered by other parameters of this function}
  }}

\item{html_folder}{the folder containing all the html}

\item{api}{A folder containing the R script using plumber called api.R and all its dependencies}
}
\description{
Deploy R api plumber scripts, HTML files or other images create the Docker image, add the build to Cloud Build and deploy to Cloud Run
}
\details{
These deploy containers to Cloud Run, a scale 0-to-millions container-as-a-service on Google Cloud Platform.
}
\section{cr_deploy_html}{

Deploy html files to a nginx server on Cloud Run.

Supply the html folder to host it on Cloud Run.  Builds the dockerfile with the html within it, then deploys to Cloud Run

Will add a \code{default.template} file to the html folder that holds the nginx configuration
}

\section{cr_deploy_plumber}{


The entrypoint for CloudRun will be via a plumber script called api.R - this should be included in your local folder to deploy.
From that api.R you can source or call other resources in the same folder, using relative paths.

The function will create a local folder called "deploy" and a tar.gz of that folder which is what is being uploaded to Google Cloud Storage
}

\examples{
\dontrun{
cr_project_set("my-project")
cr_region_set("europe-west1")
cr_bucket_set("my-bucket")
cr_deploy_run(system.file("example/", package = "googleCloudRunner"))
}
\dontrun{
cr_project_set("my-project")
cr_region_set("europe-west1")
cr_bucket_set("my-bucket")

cr_deploy_html("my_folder")
}
\dontrun{
cr_project_set("my-project")
cr_region_set("europe-west1")
cr_bucket_set("my-bucket")

cr_deploy_plumber(system.file("example/", package = "googleCloudRunner"))
}
}
\seealso{
For scheduling Cloud Run apps \link{cr_run_schedule_http}

\link{cr_deploy_run_website} which has more features like rending Rmd files and deploying upon each git commit

Other Deployment functions: 
\code{\link{cr_deploy_docker_trigger}()},
\code{\link{cr_deploy_docker}()},
\code{\link{cr_deploy_packagetests}()},
\code{\link{cr_deploy_pkgdown}()},
\code{\link{cr_deploy_run_website}()},
\code{\link{cr_deploy_r}()}
}
\concept{Deployment functions}
