% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildtriggers.R
\name{cr_buildtrigger_edit}
\alias{cr_buildtrigger_edit}
\title{Updates a `BuildTrigger` by its project ID and trigger ID.This API is experimental.}
\usage{
cr_buildtrigger_edit(BuildTrigger, triggerId, projectId = cr_project_get())
}
\arguments{
\item{BuildTrigger}{The \link{BuildTrigger} object to update to}

\item{triggerId}{ID of the `BuildTrigger` to edit or a previous \code{BuildTriggerResponse} object that will be edited}

\item{projectId}{ID of the project that owns the trigger}
}
\description{
Seems not to work at the moment (issue #16)
}
\examples{

\dontrun{

github <- GitHubEventsConfig("MarkEdmondson1234/googleCloudRunner",
                            branch = "master")
bt2 <- cr_buildtrigger("trig2",
                       trigger = github,
                       build = "inst/cloudbuild/cloudbuild.yaml")
bt3 <- BuildTrigger(
  filename = "inst/cloudbuild/cloudbuild.yaml",
  name = "edited1",
  tags = "edit",
  github = github,
  disabled = TRUE,
  description = "edited trigger")

edited <- cr_buildtrigger_edit(bt3, triggerId = bt2)

}

}
\seealso{
Other BuildTrigger functions: 
\code{\link{BuildTrigger}()},
\code{\link{GitHubEventsConfig}()},
\code{\link{cr_buildtrigger_copy}()},
\code{\link{cr_buildtrigger_delete}()},
\code{\link{cr_buildtrigger_get}()},
\code{\link{cr_buildtrigger_list}()},
\code{\link{cr_buildtrigger_repo}()},
\code{\link{cr_buildtrigger_run}()},
\code{\link{cr_buildtrigger}()}
}
\concept{BuildTrigger functions}
