% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudscheduler.R
\name{Job}
\alias{Job}
\title{Job Schedule Object}
\usage{
Job(
  attemptDeadline = NULL,
  pubsubTarget = NULL,
  httpTarget = NULL,
  timeZone = NULL,
  description = NULL,
  appEngineHttpTarget = NULL,
  status = NULL,
  retryConfig = NULL,
  state = NULL,
  name = NULL,
  lastAttemptTime = NULL,
  scheduleTime = NULL,
  schedule = NULL,
  userUpdateTime = NULL
)
}
\arguments{
\item{attemptDeadline}{The deadline for job attempts}

\item{pubsubTarget}{Pub/Sub target}

\item{httpTarget}{A HTTP target object \link{HttpTarget}}

\item{timeZone}{Specifies the time zone to be used in interpreting}

\item{description}{Optionally caller-specified in CreateJob or}

\item{appEngineHttpTarget}{App Engine HTTP target}

\item{status}{Output only}

\item{retryConfig}{Settings that determine the retry behavior}

\item{state}{Output only}

\item{name}{Optionally caller-specified in CreateJob, after}

\item{lastAttemptTime}{Output only}

\item{scheduleTime}{Output only}

\item{schedule}{A cron schedule e.g. \code{"15 5 * * *"}}

\item{userUpdateTime}{Output only}
}
\value{
Job object
}
\description{
Job Schedule Object
}
\details{
Configuration for a job.The maximum allowed size for a job is 100KB.
}
\seealso{
Other Cloud Scheduler functions: 
\code{\link{HttpTarget}()},
\code{\link{cr_build_schedule_http}()},
\code{\link{cr_schedule_delete}()},
\code{\link{cr_schedule_get}()},
\code{\link{cr_schedule_list}()},
\code{\link{cr_schedule_pause}()},
\code{\link{cr_schedule_run}()},
\code{\link{cr_schedule}()}
}
\concept{Cloud Scheduler functions}
