% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_dropouts.R
\name{delete_dropouts}
\alias{delete_dropouts}
\title{Delete dropouts}
\usage{
delete_dropouts(
  oTree,
  final_apps = NULL,
  final_pages = NULL,
  saved_vars = NULL,
  inconsistent = NULL,
  reason = "ENC",
  info = FALSE
)
}
\arguments{
\item{oTree}{A list of data frames created
with \code{\link[=import_otree]{import_otree()}}.}

\item{final_apps}{Character string or character vector.
The name(s) of the app(s) at which the participants have to finish the
experiment.}

\item{final_pages}{Character string or character vector.
The name(s) of the page(s) at which the participants have to finish the
experiment.}

\item{saved_vars}{Character string or character vector.
The name(s) of variable(s) that need(s) to be
stored in the list of information on deleted cases
in \code{$info$deleted_cases}.}

\item{inconsistent}{Character string.
Should the function continue or be stopped if
at least one participant has inconsistent end_pages, inconsistent end_apps,
or both? To continue, type \code{"yes"},
to stop the function, type \code{"no"}.}

\item{reason}{Character string.
The reason for deletion that should be stored in
the list of information on deleted cases in \code{$info$deleted_cases}.}

\item{info}{Logical. \code{TRUE} if a brief information on the dropout
deletion process should be printed.}
}
\value{
This function returns a duplicate of the original list of data frames
but without the deleted cases.

It adds information on the deleted cases to \code{$info$deleted_cases}. (This
list is also filled by other functions.)

In this list, you can find the following information:
\itemize{
\item \code{$full} = A data frame that contains information
on all participants who did not finish the study;
it shows their participant codes, the names of the apps in which they
left the experiment,
the names of the pages in which they left the experiment,
the names of the app data frames in which this information was found, and
the dropout reason (\code{"ENC"}, experiment not completed, combined
with the name of the data frame in which the dropout was observed).
Because participants usually appear in multiple app data frames,
the \code{$info$deleted_cases$full} data frame may contain several entries
for each person.
\item \code{$unique} = A data frame that contains similar information as
the \code{$full} data frame but with only one row per participant and
no information on the data frame in which the dropout was observed.
\item \code{$all_end} = A table that provides information on the app and page
combinations where participants ended the experiment.
This table also includes information for participants who did not drop out
of the experiment.
The \code{$all_end} table is only shown if an \code{$all_apps_wide} data
frame exists.
\item \code{$codes} = A vector containing the participant codes of
all deleted participants.
\item \code{$count} = The number of all deleted participants.
}

It is important to note that if only the argument \code{final_pages} is set,
this function does not distinguish between page names that reoccur in
different apps.

If the columns \code{end_app} and \code{end_page} in the output are empty,
these variables were not saved by oTree for the specific participants.
This could be because empty rows were not deleted. This can be done
by using the argument \code{del_empty = TRUE} when
using \code{\link[=import_otree]{import_otree()}}.
}
\description{
Delete the data of all participants who did not end the experiment at (a)
certain page(s) and/or app(s).

Caution 1: This function does not delete cases from the original CSV and
Excel files!

Caution 2: This function does not delete cases from custom export
data frames if they do not have a variable named \code{participant.code} and
a variable named \code{session.code}!

Caution 3: This function does not delete any data from
the \code{$Chats} data frame!
(As the interpretation of chat data depends on how participants engage with
each other, the data must be deleted with more care than deleting data in
other apps. Hence, this function does not delete data in this data frame.
Please do this manually if necessary!)
}
\examples{
# Use package-internal list of oTree data frames
oTree <- gmoTree::oTree

# First, show some row numbers
print(paste(nrow(oTree$all_apps_wide), nrow(oTree$survey),
nrow(oTree$Time), nrow(oTree$Chats)))

# Delete all cases that didn't end the experiment on the page "Demographics"
# within the app "survey"
oTree2 <- delete_dropouts(oTree,
                         final_apps = c("survey"),
                         final_pages = c("Demographics"))

# Show row numbers again
print(paste(nrow(oTree2$all_apps_wide), nrow(oTree2$survey),
nrow(oTree2$Time), nrow(oTree2$Chats)))

# Delete all cases that didn't end the experiment on the page "Demographics"
# This page can be in any app
oTree2 <- delete_dropouts(oTree, final_pages = "Demographics")

# Show row numbers again
print(paste(nrow(oTree2$all_apps_wide), nrow(oTree2$survey),
nrow(oTree2$Time), nrow(oTree2$Chats)))

# Delete all cases that didn't end the experiment on
# any page in the app "survey"
oTree <- delete_dropouts(oTree, final_apps = "survey")

# Show row numbers again
print(paste(nrow(oTree2$all_apps_wide), nrow(oTree2$survey),
nrow(oTree2$Time), nrow(oTree2$Chats)))

# Get list of information on all deleted cases
# (If there is already a list, the new list is added to it!)
oTree2$info$deleted_cases
}
\keyword{oTree}
