% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_dag.R
\name{metropolis-hastings sampling}
\alias{metropolis-hastings sampling}
\alias{mh_u}
\alias{mh_sphere}
\title{Upper Cholesky factor sampling using Metropolis-Hastings}
\usage{
mh_u(N = 1, p = 3, dag = NULL, h = 100, eps = 0.1)

mh_sphere(N = 1, k, i = 1, h = 100, eps = 0.01)
}
\arguments{
\item{N}{Number of samples.}

\item{p}{Dimension of the upper Cholesky factor.}

\item{dag}{An
\href{https://CRAN.R-project.org/package=igraph}{igraph} acyclic
digraph specifying the zero pattern in the upper Cholesky
factor of the sampled matrices. Nodes must be in ancestral
order, with the first one having no parents.}

\item{h}{Heating phase size for \code{\link[=mh_sphere]{mh_sphere()}}.}

\item{eps}{Perturbation variance for \code{\link[=mh_sphere]{mh_sphere()}}.}

\item{k}{Dimension of the hemisphere from which the sample is taken.}

\item{i}{Integer, power of the first coordinate in the density.}
}
\description{
Metropolis-Hasting algorithms to sample the upper Cholesky factor, using
positive hemispheres of different dimensions. A zero pattern may be specified
using an acyclic digraph.
}
\details{
Function \code{\link[=mh_u]{mh_u()}} returns a sample of \code{N} upper Cholesky factors whose rows have
been generated using \code{\link[=mh_sphere]{mh_sphere()}}. The dimensions of the hemispheres used to sample vary
depending both on the row number of the Cholesky factor, and whether there is a zero pattern
specified by \code{dag}.

The details of the algorithm implemented by \code{\link[=mh_sphere]{mh_sphere()}} can be found in the
paper Córdoba et al. (2018), including a discussion on
theoretical convergence and numerical experiments for
choosing its hyper parameters \code{h} and \code{eps}.
}
\examples{
## Upper Cholesky factor sampling 
# Generate a random acyclic digraph 
dag <- rgraph(p = 3, d = 0.5, dag = TRUE)
igraph::print.igraph(dag)

# Generate an upper Cholesky factor complying with such zero pattern
mh_u(dag = dag)
# We may also generate it with no zero pattern (full upper triangular)
mh_u()
## Hemisphere sampling
# 3D hemisphere from a density proportional to the square of the first coordinate
mh_sphere(N = 4, k = 3, i = 2)
}
\references{
Córdoba I., Varando G., Bielza C., Larrañaga P. A fast
Metropolis-Hastings method for generating random correlation matrices. \emph{Lecture Notes in
Computer Science} (IDEAL 2018), vol 11314, pp. 117-124, 2018.
}
\author{
Gherardo Varando \email{gherardo.varando@math.ku.dk}
}
