% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glottoplot.R
\name{glottoplot}
\alias{glottoplot}
\title{Visualize glottodata or glottodistances}
\usage{
glottoplot(
  glottodata = NULL,
  glottodist = NULL,
  type = NULL,
  k = NULL,
  rm.na = FALSE,
  color = NULL,
  ptsize = NULL,
  label = NULL,
  filename = NULL
)
}
\arguments{
\item{glottodata}{glottodata table}

\item{glottodist}{A dist object created with \code{\link{glottodist}}}

\item{type}{The type of plot: "heatmap", "nmds", or "stress". Default is heatmap if nothing is provided.}

\item{k}{Number of dimensions. Either 2 or 3 for nmds.}

\item{rm.na}{Whether na's should be removed (default is FALSE)}

\item{color}{glottovar to be used to color features (optional). Run glottovars() to see the options.}

\item{ptsize}{Size of points between 0 and 1 (optional)}

\item{label}{glottovar to be used to label features (optional). Run glottovars() to see the options.}

\item{filename}{Optional filename if output should be saved.}
}
\value{
a visualization of a glotto(sub)data or glottodist object, which can be saved with glottosave()
}
\description{
This function offers different types of visualizations for linguistic data and linguistic distances.
}
\examples{
\donttest{
# Plot glottodist as nmds:
glottodata <- glottoget("demodata", meta = TRUE)
glottodist <- glottodist(glottodata = glottodata)
glottoplot(glottodist = glottodist, type = "nmds", k = 3, color = "family", label = "name")

# Plot missing data:
glottodata <- glottoget("demodata", meta = TRUE)
glottodata <- glottosimplify(glottodata)
glottoplot(glottodata = glottodata, type = "missing")
}
}
