% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glottofilter.R
\name{glottofilterflex}
\alias{glottofilterflex}
\title{Flexible version of glottofilter}
\usage{
glottofilterflex(glottodata, colname, select)
}
\arguments{
\item{glottodata}{glottodata table}

\item{colname}{Character with a single column name}

\item{select}{Things to be selected in that column}
}
\description{
This is a more flexible alternative to glottofilter, allowing for negative selections.
}
\examples{
\donttest{
glottodata <- glottoget("glottobase")
glottofilterflex(glottodata = glottodata, colname = "family",
select = "Indo-European")
glottofilterflex(glottodata = glottodata, colname = "family",
select = -"Indo-European")
glottofilterflex(glottodata = glottodata, colname = "country",
select = c("Germany", "Netherlands") )
glottofilterflex(glottodata = glottodata, colname = "country",
select = -c("Germany", "Netherlands") )
glottofilterflex(glottodata = glottodata, colname = "continent",
select = -c("South America", "Europe", "Asia", "Oceania", "Africa") )
}
}
\keyword{internal}
