% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{generate_cv_folds}
\alias{generate_cv_folds}
\title{Generate cross-validation folds}
\usage{
generate_cv_folds(
  data,
  method = "k-fold",
  block_method = "predictors_autocorrelation",
  block_size = NULL,
  k = 10,
  predictor_raster = NULL,
  model_residuals = NULL,
  coords = c("decimalLongitude", "decimalLatitude")
)
}
\arguments{
\item{data}{A `data.frame` with at least presence-absence data (`pa`), coordinates, and optionally a `timestamp`.}

\item{method}{The cross-validation strategy. One of: `"k-fold"`, `"spatial_blocks"`, `"temporal_blocks"`.}

\item{block_method}{For spatial blocks, how to determine block size. One of: `"residuals_autocorrelation"`, `"predictors_autocorrelation"`, `"manual"`.}

\item{block_size}{Numeric. Manual block size in meters (used if `block_method = "manual"`).}

\item{k}{Integer. Number of folds to generate.}

\item{predictor_raster}{A `terra::SpatRaster` used for estimating spatial autocorrelation (only needed if `block_method = "predictors_autocorrelation"`).}

\item{model_residuals}{A `data.frame` with residuals and coordinates (only needed if `block_method = "residuals_autocorrelation"`).}

\item{coords}{A character vector of length 2 indicating the longitude and latitude column names.}
}
\value{
A list with the following elements:
\describe{
  \item{folds}{A vector of fold assignments (one per row in `data`).}
  \item{method}{The CV method used.}
  \item{block_method}{The spatial block size method (if applicable).}
  \item{block_size}{The estimated or manual block size (in meters), if spatial blocks were used.}
}
}
\description{
Creates cross-validation fold assignments for presence-absence or presence-only data,
supporting three types of strategies: k-fold, spatial blocks (through blockCV R package), and temporal blocks.
}
