% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.glmtrans.R
\name{predict.glmtrans}
\alias{predict.glmtrans}
\title{Predict for new data from a "glmtrans" object.}
\usage{
\method{predict}{glmtrans}(
  object,
  newx,
  type = c("link", "response", "class", "integral response"),
  ...
)
}
\arguments{
\item{object}{an object from class "glmtrans", which comes from the output of function \code{glmtrans}.}

\item{newx}{the matrix of new values for predictors at which predictions are to be made. Should be in accordance with the data for training \code{object}.}

\item{type}{the type of prediction. Default = "link".}

\item{...}{additional arguments.
\itemize{
\item{"link"}{the linear predictors. When \code{family = "gaussian"}, it is the same as the predicited responses.}
\item{"response"}{gives the predicited probabilities when \code{family = "binomial"}, the predicited mean when \code{family = "poisson"}, and the predicited responses when \code{family = "gaussian"}.}
\item{"class"}{the predicited 0/1 responses for lositic distribution. Applies only when \code{family = "binomial"}.}
\item{"integral response"}{the predicited integral response for Poisson distribution. Applies only when \code{family = "poisson"}.}
}}
}
\value{
the predicted result on new data, which depends on \code{type}.
}
\description{
Predict from a "glmtrans" object based on new observation data. There are various types of output available.
}
\examples{
set.seed(1, kind = "L'Ecuyer-CMRG")

# fit a logistic model
D.training <- models("binomial", type = "all", K = 1, p = 500)
D.test <- models("binomial", type = "target", n.target = 10, p = 500)
fit.binomial <- glmtrans(D.training$target, D.training$source, family = "binomial")

predict(fit.binomial, D.test$target$x, type = "link")
predict(fit.binomial, D.test$target$x, type = "response")
predict(fit.binomial, D.test$target$x, type = "class")

\donttest{
# fit a Poisson model
D.training <- models("poisson", type = "all", K = 1, p = 500)
D.test <- models("poisson", type = "target", n.target = 10, p = 500)
fit.poisson <- glmtrans(D.training$target, D.training$source, family = "poisson")

predict(fit.poisson, D.test$target$x, type = "response")
predict(fit.poisson, D.test$target$x, type = "integral response")
}
}
\references{
Tian, Y. and Feng, Y., 2021. \emph{Transfer learning with high-dimensional generalized linear models. Submitted.}
}
\seealso{
\code{\link{glmtrans}}.
}
