% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dilution}
\alias{dilution}
\title{Dilution Assay}
\format{
A data frame with 21 rows and 2 variables:
\describe{
  \item{Count}{a numeric vector indicating the count of virus particles.}
  \item{Dilution}{a numeric vector indicating the dilution volume.}
}
}
\source{
https://sada2013.sciencesconf.org/16138/glmSession4_Cotonou.pdf
}
\usage{
data(dilution)
}
\description{
These data are counts of virus
particles at 5 different dilutions. There are 4
replicate counts at each dilution except the last
for which there are 5 counts. The aim is to
estimate the number of virus particles per unit volume.
}
\examples{
data(dilution)
with(dilution,plot(Dilution,Count,pch=20,xlab="Dilution volume",
                   ylab="Count of virus particles"))
}
\keyword{datasets}
