% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm.R
\name{predict.overglm}
\alias{predict.overglm}
\title{Predictions for Negative Binomial and Beta-Binomial regression models}
\usage{
\method{predict}{overglm}(object, ..., newdata, se.fit = FALSE, type = c("link", "response"))
}
\arguments{
\item{object}{an object of class overglm which is obtained from the fit of a negative binomial or beta-binomial regression model.}

\item{...}{further arguments passed to or from other methods.}

\item{newdata}{an (optional) \code{data frame} in which to look for variables with which to predict. If omitted, the fitted linear predictors are used.}

\item{se.fit}{an (optional) logical switch indicating if standard errors are required. By default, \code{se.fit} is set to be FALSE.}

\item{type}{an (optional) character string giving the type of prediction required. The default, "link", is on the scale of the linear predictors, and the alternative, "response", is on the scale of the response variable.}
}
\value{
A matrix with so many rows as \code{newdata} and one column with the predictions. If \code{se.fit=}TRUE then a second column with estimates standard errors is included.
}
\description{
Produces predictions and optionally estimates standard errors of those predictions from a fitted negative binomial or beta-binomial regression model.
}
\examples{
fit1 <- overglm(tumors ~ group, family="nb3(log)", data=mammary)
newdata <- data.frame(group=as.factor(c("control","retinoid")))
predict(fit1,newdata=newdata,type="response",se.fit=TRUE)

fit2 <- overglm(cbind(cells,200-cells) ~ tnf + ifn + tnf*ifn, family="bb(logit)", data=cellular)
newdata <- data.frame(tnf=c(0,100),ifn=c(100,0))
predict(fit2,newdata=newdata,type="response",se.fit=TRUE)

}
