% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.glmmfields}
\alias{plot.glmmfields}
\title{Plot predictions from an glmmfields model}
\usage{
\method{plot}{glmmfields}(
  x,
  type = c("prediction", "spatial-residual", "residual-vs-fitted"),
  link = TRUE,
  ...
)
}
\arguments{
\item{x}{An object returned by \code{\link{glmmfields}}}

\item{type}{Type of plot}

\item{link}{Logical: should the plots be made on the link scale
or on the natural scale?}

\item{...}{Other arguments passed to \code{\link{predict.glmmfields}}}
}
\description{
Plot predictions from an glmmfields model
}
\examples{
\donttest{
# Spatiotemporal example:
set.seed(1)
s <- sim_glmmfields(n_draws = 12, n_knots = 12, gp_theta = 1.5,
gp_sigma = 0.2, sd_obs = 0.1)
# options(mc.cores = parallel::detectCores()) # for parallel processing
m <- glmmfields(y ~ 0, time = "time",
 lat = "lat", lon = "lon", data = s$dat,
 nknots = 12, iter = 600, chains = 1)
x <- plot(m, type = "prediction")
x
x + ggplot2::scale_color_gradient2()
plot(m, type = "spatial-residual")
plot(m, type = "residual-vs-fitted")
}
}
