% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmm.hp.r
\name{glmm.hp}
\alias{glmm.hp}
\title{Hierarchical Partitioning of Marginal R2 for Generalized Mixed-Effect Models}
\usage{
glmm.hp(mod, type = "adjR2")
}
\arguments{
\item{mod}{Fitted lme4,nlme,glmmTMB,glm or lm model objects.}

\item{type}{The type of R-square of lm, either "R2" or "adjR2", in which "R2" is unadjusted R-square and "adjR2" is adjusted R-square, the default is "adjR2". The adjusted R-square is calculated using Ezekiel's formula (Ezekiel 1930) for lm.}
}
\value{
\item{r.squaredGLMM}{The R2 for the full model.}

\item{hierarchical.partitioning}{A matrix containing individual effects and percentage of individual effects towards total (marginal) R2 for each predictor.}
}
\description{
Hierarchical Partitioning of Marginal R2 for Generalized Mixed-Effect Models
}
\details{
This function conducts hierarchical partitioning to calculate the individual contributions of each predictor towards total (marginal) R2 for Generalized Linear Mixed-effect Model (including lm,glm and glmm). The marginal R2 is the output of r.squaredGLMM in MuMIn package for glm and glmm.
}
\examples{
library(MuMIn)
library(lme4)
mod1 <- lmer(Sepal.Length ~ Petal.Length+Petal.Width +(1 | Species),data = iris)
r.squaredGLMM(mod1)
glmm.hp(mod1)
plot(glmm.hp(mod1))
mod2 <- glm(Sepal.Length ~ Petal.Length+Petal.Width,data = iris)
r.squaredGLMM(mod2)
glmm.hp(mod2)
plot(glmm.hp(mod2))
mod3 <- lm(Sepal.Length ~ Petal.Length+Petal.Width,data = iris)
glmm.hp(mod3,type="R2")
glmm.hp(mod3,type="adjR2")
}
\references{
\itemize{
\item Lai J.,Zou Y., Zhang S.,Zhang X.,Mao L.(2022)glmm.hp: an R package for computing individual effect of predictors in generalized linear mixed models.Journal of Plant Ecology,15(6):1302-1307<DOI:10.1093/jpe/rtac096>
\item Lai J.,Zou Y., Zhang J.,Peres-Neto P.(2022) Generalizing hierarchical and variation partitioning in multiple regression and canonical analyses using the rdacca.hp R package.Methods in Ecology and Evolution,13(4):782-788<DOI:10.1111/2041-210X.13800>
\item Chevan, A. & Sutherland, M. (1991). Hierarchical partitioning. American Statistician, 45, 90-96. doi:10.1080/00031305.1991.10475776
\item Nimon, K., Oswald, F.L. & Roberts, J.K. (2013). Yhat: Interpreting regression effects. R package version 2.0.0.
\item Nakagawa, S., & Schielzeth, H. (2013). A general and simple method for obtaining R2 from generalized linear mixed-effects models. Methods in Ecology and Evolution, 4(2), 133-142.
\item Nakagawa, S., Johnson, P. C., & Schielzeth, H. (2017). The coefficient of determination R2 and intra-class correlation coefficient from generalized linear mixed-effects models revisited and expanded. Journal of the Royal Society Interface, 14(134), 20170213.
\item Ezekiel, M. (1930) Methods of Correlational Analysis. Wiley, New York.
}
}
\author{
{Jiangshan Lai} \email{lai@njfu.edu.cn}

{Kim Nimon} \email{kim.nimon@gmail.com}
}
