% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{ps_newtonRaphson}
\alias{ps_newtonRaphson}
\title{Newton-Raphson algorithm when parameters may not be estimable outside of their parameter space}
\usage{
ps_newtonRaphson(
  rootfun,
  x,
  xabstol = 1e-05,
  derivdelta = xabstol,
  yabstol = 1e-05,
  niter = 100,
  extraiter = 0
)
}
\arguments{
\item{rootfun}{a function taking a single numeric value. The algorithm searches for a root (zero) of this function.}

\item{x}{a single numeric value; starting value, not too far from the root of rootfun.}

\item{xabstol}{a single numeric value; when two consecutive iterations of the algorithm lead to x solutions with a difference larger than xabstol, 
the algorithm has not yet converged and continues to run. Set to Inf, if you want to only want to rely on yabstol.}

\item{derivdelta}{a single numeric value; the numeric delta used for numeric derivation of rootfun (assessed at x-derivdelta and x+derivdelta)}

\item{yabstol}{a single numeric value; when the algorithm leads to a y=rootfun(x) larger (in absolute value) than yabstol, the algorithm has not yet converged 
and continues to run. Set to Inf, if you want to only want to rely on xabstol.}

\item{niter}{a single integer value; the maximum number of iterations before considering that the algorithm failed to converge.}

\item{extraiter}{a single integer value; the number of extra iterations performed once convergence has been found.
This is useful to make sure that convergence is good on platforms having high floating point precision allowing to use, at the same time,
a weak convergence tolerance to make sure it converges on platforms having low floating point precision.}
}
\value{
a list object with the following fields:
\describe{
\item{\code{root}}{the x value so that rootfun(x) is as close as possible to 0}
\item{\code{f.root}}{rootfun(root)}
\item{\code{yabstol}}{the parameter of the same name}
\item{\code{iter}}{the number of iterations of the Newton-Raphson algorithm performed before reaching convergence}
\item{\code{estim.prec}}{the latest move (on the x variable) done before convergence}
\item{\code{prevx}}{the previous x value, in the algorithm, just before x=root was reached}
\item{\code{prevy}}{rootfun(prevx)}
\item{\code{prevder}}{numeric derivative of rootfun at prevx}
}
}
\description{
This is used by \code{\link{confint_contrast.default}} to find the lower and upper boundaries of the confidence interval so that they have a P-value equal to 1-level.
This makes it possible to compute contrast on log-binomial models when solutions are close to the boundaries of the parameter space 
and Newton-Raphson may compute some intermediate values outside of the valid parameter space, leading to P-values equal to NA.
}
\details{
It assumes that \code{rootfun} is NA above the upper boundary of the parameter space and below the lower boundary of the parameter space.
The parameter space must not have "holes" (i.e. valid, then invalid, then valid again).
Invalid values are described by NA. The actual interval of valid values are automatically found by the algorithm, so you do 
not have to explicitly specify the minimum and maximum values of the parameter space.
}
