% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{fixcoef}
\alias{fixcoef}
\alias{fixcoef.lmerMod}
\alias{fixcoef.glmerMod}
\alias{fixcoef.lmerModLmerTest}
\alias{fixcoef.lme}
\alias{fixcoef.multinom}
\alias{fixcoef.mlm}
\alias{fixcoef.default}
\title{Generic function to get fixed effects of a model}
\usage{
fixcoef(model, ...)

\method{fixcoef}{lmerMod}(model, ...)

\method{fixcoef}{glmerMod}(model, ...)

\method{fixcoef}{lmerModLmerTest}(model, ...)

\method{fixcoef}{lme}(model, ...)

\method{fixcoef}{multinom}(model, ...)

\method{fixcoef}{mlm}(model, ...)

\method{fixcoef}{default}(model, ...)
}
\arguments{
\item{model}{a fitted statistical model}

\item{...}{argument unused by \code{\link{p_value_contrast.default}} but that may be useful to some specializations.}
}
\value{
Simple numeric vector with one item for each fixed effect of the model.
}
\description{
This is a generic S3 function that gets point estimates of fixed effects of a statistical model, implemented on a wide range of models and that can be extended to new models.
}
\details{
It must return only estimates of fixed-effects of a model. Random effects are ignored.
The \code{\link[base:names]{names}} of the element of this vector must be consistent
with the \code{rownames} and \code{colnames}
of the variance-covariance matrix that \code{\link{vcov_fixcoef}} returns.
The \code{vcov_fixcoef} function, on the same model, must return a matrix
with the same number and names of rows and columns as the length of the vector returned by \code{fixcoef}.

The functions \code{\link{vcov_fixcoef}} and \code{\link{fixcoef}} would be pointless if the behavior of
\code{\link[stats:vcov]{vcov}} and \code{\link[stats:coef]{coef}} were not inconsistent from package to package.

\code{fixcoef} and \code{vcov_fixcoef}, together with \code{\link{df_for_wald}} are used by \code{\link{p_value_contrast.default}}
}
\section{Methods (by class)}{
\itemize{
\item \code{lmerMod}: implementation for \code{\link[lme4:lmer]{lme4::lmer}}

\item \code{glmerMod}: implementation for \code{\link[lme4:glmer]{lme4::glmer}}

\item \code{lmerModLmerTest}: implementation for \code{\link[lmerTest:lmer]{lmerTest::lmer}}

\item \code{lme}: implementation for \code{\link[nlme:lme]{nlme::lme}}

\item \code{multinom}: implementation for \code{\link[nnet:multinom]{nnet::multinom}}

\item \code{mlm}: implementation for multiple responses linear models generated by \code{\link[stats:lm]{stats::lm}} when the response is a matrix.

\item \code{default}: default implementation, simply calls coef(model).
}}

\examples{
data(mtcars)
fixcoef(lm(data=mtcars, hp ~ 1)) # get mean horse power of cars listed in mtcars
}
\seealso{
Other Wald-related functions: 
\code{\link{df_for_wald}()},
\code{\link{p_value_contrast}()},
\code{\link{vcov_fixcoef}()}
}
\concept{Wald-related functions}
