% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.r
\docType{data}
\name{brfss}
\alias{brfss}
\title{Behavioral Risk Factor Surveillance System 2017 (BRFSS 2017)}
\format{A data frame with 444023 observations on the following 10 variables.
\describe{
\item{\code{OBESE}}{(original : \code{_RFBMI5}) Adults who have a body mass index greater than 25.00 (Overweight or Obese)

(1) No \cr (2) Yes}
\item{\code{PA300}}{(original : \code{_PA300R2}) Adults that participated in 300 minutes (or vigorous equivalent minutes) of physical activity per week

(1) 301+ minutes \cr (2) 1-300 minutes \cr (3) 0 minutes
\cr
}
\item{\code{FRTLT1A}}{(original : \code{_FRTLT1A}) Consume fruit 1 or more times per day

(1) Yes \cr
(2) No}
\item{\code{VEGLT1A}}{(original : \code{_VEGLT1A}) Consume vegetables 1 or more times per day

(1) Yes\cr
(2) No}
\item{\code{SMOKER}}{(original : \code{_SMOKER3}) Four-level smoker status

(1) Never smoked\cr
(2) Former smoker\cr
(3) Occational smoker\cr
(4) Everyday smoker
}
\item{\code{DRNK30}}{(original : \code{DRNKANY5}) Adults who reported having had at least one drink of alcohol in the past 30 days

(1) No\cr
(2) Yes}
\item{\code{SEX}}{Respondents Sex}
\item{\code{INCOME}}{(original : \code{INCOME2}) Income level}
\item{\code{STATE}}{(original : \code{_STATE}) State FIPS code}
\item{\code{REGION}}{Region to which the state belongs}
\item{\code{PARTY}}{The party that won the 2016 presidential election by state}
}}
\source{
\url{https://www.cdc.gov/brfss/}

\url{https://doi.org/10.7910/DVN/42MVDX}
}
\description{
This data is comprised of questions related to healthy lifestyles, such as obesity, exercise time, eating habits, and smoking and drinking behaviors from the BRFSS 2017 survey. State is a group variable indicating the respondent's residential state. The data includes both individual-level (level-1) and group-level (level-2) covariates. The level-1 covariates include respondents' gender and income level. The level-2 covariates are regions of the United States and political parties which won the 2016 presidential election in the state.
}
\examples{
data("brfss")
\donttest{
brfss1000 = brfss[sample(1:nrow(brfss), 1000),]

# Model 1: LCA
lca = glca(item(OBESE, PA300, FRTLT1A, VEGLT1A, SMOKER, DRNK30) ~ 1,
   data = brfss1000, nclass = 3)
summary(lca)

# Model 2: MGLCA
mglca = glca(item(OBESE, PA300, FRTLT1A, VEGLT1A, SMOKER, DRNK30) ~ 1,
   group = SEX, data = brfss1000, nclass = 3)
summary(mglca)

# Model 3: MGLCA with covariate(s)
mglcr = glca(item(OBESE, PA300, FRTLT1A, VEGLT1A, SMOKER, DRNK30) ~ REGION,
   group = SEX, data = brfss1000, nclass = 3)
summary(mglcr)
coef(mglcr)

# Model 4: MLCA
mlca = glca(item(OBESE, PA300, FRTLT1A, VEGLT1A, SMOKER, DRNK30) ~ 1,
   group = STATE, data = brfss1000, nclass = 3, ncluster = 2)
summary(mlca)

# Model 5: MLCA with level-1 covariate(s) only
mlcr = glca(item(OBESE, PA300, FRTLT1A, VEGLT1A, SMOKER, DRNK30) ~ SEX,
            group = STATE, data = brfss1000, nclass = 3, ncluster = 2)
summary(mlcr)
coef(mlcr)

# Model 6: MLCA with level-1 and level-2 covariate(s)
# (SEX: level-1 covariate, PARTY: level-2 covariate)
mlcr2 = glca(item(OBESE, PA300, FRTLT1A, VEGLT1A, SMOKER, DRNK30) ~ SEX + PARTY,
             group = STATE, data = brfss1000, nclass = 3, ncluster = 2)
summary(mlcr2)
coef(mlcr2)
}
}
\references{
Centers for Disease Control and Prevention. (2017). 2017 Behavioral Risk Factor Surveillance System Survey Data. Retrieved from \url{https://www.cdc.gov/brfss/}.

MIT Election Data and Science Lab, (2017). U.S. President 1976-2016. Retrieved from \doi{10.7910/DVN/42MVDX}.
}
\keyword{datasets}
