% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tag.r
\docType{methods}
\name{tags}
\alias{tags}
\alias{tags,git_repository-method}
\title{Tags}
\usage{
tags(repo)

\S4method{tags}{git_repository}(repo)
}
\arguments{
\item{repo}{The repository}
}
\value{
list of tags in repository
}
\description{
Tags
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Commit a text file
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Create tag
tag(repo, "Tagname", "Tag message")

## List tags
tags(repo)
}
}
\keyword{methods}

