% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igray.R
\name{theme_igray}
\alias{theme_igray}
\title{Inverse gray theme}
\usage{
theme_igray(base_size = 12, base_family = "")
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}
}
\description{
Theme with white panel and gray background.
}
\section{Details}{


This theme inverts the colors in the \code{\link{theme_gray}}, a
white panel and a light gray area around it. This keeps a white
background for the color scales like \code{\link{theme_bw}}. But
by using a gray background, the plot is closer to the
typographical color of the document, which is the motivation for
using a gray panel in \code{\link{theme_gray}}. This is
similar to the style of plots in Stata and Tableau.
}

\examples{


library("ggplot2")
p <- ggplot(mtcars) +
    geom_point(aes(x = wt, y = mpg, colour=factor(gear))) +
    facet_wrap(~am)
p + theme_igray()



}
\seealso{
\code{\link{theme_gray}}, \code{\link{theme_bw}}

Other themes: \code{\link{theme_base}},
  \code{\link{theme_foundation}}, \code{\link{theme_par}},
  \code{\link{theme_solid}}
}
