% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel.R
\name{theme_excel}
\alias{theme_excel}
\title{ggplot color theme based on old Excel plots}
\usage{
theme_excel(base_size = 12, base_family = "", horizontal = TRUE)
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}

\item{horizontal}{\code{logical}. Horizontal axis lines?}
}
\value{
An object of class \code{\link{theme}}.
}
\description{
Theme to replicate the ugly monstrosity that was the old
gray-background Excel chart. Please never use this.
}
\examples{


library("ggplot2")
# Old line color
p <- ggplot(mtcars) +
     geom_point(aes(x = wt, y = mpg, colour=factor(gear))) +
     facet_wrap(~am)
p + theme_excel() + scale_colour_excel()

# Old fill color palette
ggplot(mpg, aes(x = class, fill = drv)) +
  geom_bar() +
  scale_fill_excel('fill') +
  theme_excel()




}
