% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpiestats.R
\name{ggpiestats}
\alias{ggpiestats}
\title{Pie charts with statistical tests}
\usage{
ggpiestats(data = NULL, main, condition = NULL, factor.levels = NULL,
  stat.title = NULL, title = NULL, caption = NULL, legend.title = NULL,
  facet.wrap.name = NULL, k = 3, facet.proptest = TRUE, messages = TRUE)
}
\arguments{
\item{data}{The data as a data frame.}

\item{main}{A string naming the variable to use as the rows in the
contingency table.}

\item{condition}{A string naming the variable to use as the columns in the
contingency table.}

\item{factor.levels}{A character vector with labels for factor levels of
\code{main} variable.}

\item{stat.title}{Title for the effect being investigated with the chi-square
test.}

\item{title}{The text for the plot title.}

\item{caption}{The text for the plot caption.}

\item{legend.title}{Title of legend.}

\item{facet.wrap.name}{The text for the facet_wrap variable label.}

\item{k}{Number of decimal places expected for results.}

\item{facet.proptest}{Decides whether proprotion test for \code{main} variable is
to be carried out for each level of \code{condition} (Default: \code{TRUE}).}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}
}
\description{
Pie charts for categorical data with statistical details
included in the plot as a subtitle.
}
\examples{

library(ggplot2)

# simple function call with the defaults
ggstatsplot::ggpiestats(
data = datasets::iris,
main = Species
)

# more detailed function call
ggstatsplot::ggpiestats(
data = datasets::mtcars,
main = am,
condition = cyl,
factor.levels = c("zero", "one"),
stat.title = "interaction",
title = "Dataset: mtcars",
caption = "This is a demo",
legend.title = "transmission",
facet.wrap.name = "No. of cylinders",
facet.proptest = TRUE
)

}
\author{
Indrajeet Patil
}
