% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-cps-spct.R
\name{scale_y_cps_continuous}
\alias{scale_y_cps_continuous}
\title{Counts-per-second  y-scale}
\usage{
scale_y_cps_continuous(
  unit.exponent = 0,
  name = cps_label(unit.exponent = unit.exponent, format = format, label.text =
    label.text, scaled = scaled, normalized = ifelse(is.numeric(normalized),
    round(normalized, 1), unique(normalized)), axis.symbols = axis.symbols),
  labels = SI_pl_format(exponent = unit.exponent),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels()[["cps"]],
  scaled = FALSE,
  normalized = FALSE,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE),
  ...
)
}
\arguments{
\item{unit.exponent}{integer}

\item{name}{The name of the scale, used for the axis-label.}

\item{labels}{The tick labels or a function to generate them.}

\item{format}{character string, "R", "R.expression", "R.character", or
"LaTeX".}

\item{label.text}{character Textual portion of the labels.}

\item{scaled}{logical If \code{TRUE} relative units are assumed.}

\item{normalized}{logical (\code{FALSE}) or numeric Normalization wavelength
in manometers (nm).}

\item{axis.symbols}{logical If \code{TRUE} symbols of the quantities are
added to the \code{name}. Supported only by \code{format = "R.expression"}.}

\item{...}{other named arguments passed to \code{scale_y_continuous}}
}
\description{
Scale y continuous with defaults suitable for raw detector counts.
}
\note{
This function only alters two default arguments, please, see
  documentation for \code{\link[ggplot2]{scale_continuous}}
}
\examples{

ggplot(white_led.cps_spct) +
  geom_line() +
  scale_y_cps_continuous() +
  scale_x_wl_continuous()

ggplot(white_led.cps_spct) +
  geom_line() +
  scale_y_cps_continuous(3) +
  scale_x_wl_continuous()

ggplot(white_led.cps_spct * 1e-4) +
  geom_line() +
  scale_y_cps_continuous(scaled = TRUE) +
  scale_x_wl_continuous()

if (packageVersion("photobiology") > "0.11.4") {
  norm_led.cps_spct <- normalize(white_led.cps_spct, norm = "max")

  ggplot(norm_led.cps_spct) +
    geom_line() +
    scale_y_cps_continuous(normalized = is_normalized(norm_led.cps_spct)) +
    scale_x_wl_continuous()

  ggplot(norm_led.cps_spct) +
    geom_line() +
    scale_y_cps_continuous(normalized = getNormalized(norm_led.cps_spct)) +
    scale_x_wl_continuous()

  ggplot(norm_led.cps_spct) +
    geom_line() +
    scale_y_cps_continuous(normalized =
       normalization(norm_led.cps_spct)$norm.type) +
    scale_x_wl_continuous()
}

}
