% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-wb-irrad.R
\name{stat_wb_irrad}
\alias{stat_wb_irrad}
\alias{stat_wb_e_irrad}
\alias{stat_wb_q_irrad}
\title{Integrate irradiance for wavebands.}
\usage{
stat_wb_irrad(
  mapping = NULL,
  data = NULL,
  geom = "text",
  w.band = NULL,
  time.unit,
  unit.in,
  label.qty = "total",
  label.mult = 1,
  chroma.type = "CMF",
  label.fmt = "\%.3g",
  ypos.mult = 1.07,
  ypos.fixed = NULL,
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

stat_wb_e_irrad(
  mapping = NULL,
  data = NULL,
  geom = "text",
  w.band = NULL,
  time.unit = "second",
  unit.in = "energy",
  label.qty = "total",
  label.mult = 1,
  chroma.type = "CMF",
  label.fmt = "\%.3g",
  ypos.mult = 1.07,
  ypos.fixed = NULL,
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

stat_wb_q_irrad(
  mapping = NULL,
  data = NULL,
  geom = "text",
  w.band = NULL,
  time.unit = "second",
  unit.in = "photon",
  label.qty = "total",
  label.mult = 1,
  chroma.type = "CMF",
  label.fmt = "\%.3g",
  ypos.mult = 1.07,
  ypos.fixed = NULL,
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{w.band}{a waveband object or a list of waveband objects or numeric
vector of at least length two.}

\item{time.unit}{character or lubridate::duration}

\item{unit.in}{character One of "photon","quantum" or "energy"}

\item{label.qty}{character}

\item{label.mult}{numeric Scaling factor applied to y-integral values before
conversion into character strings.}

\item{chroma.type}{character one of "CMF" (color matching function) or "CC"
(color coordinates) or a \code{\link[photobiology]{chroma_spct}} object.}

\item{label.fmt}{character string giving a format definition for converting
y-integral values into character strings by means of function
\code{\link{sprintf}}.}

\item{ypos.mult}{numeric Multiplier constant used to scale returned
\code{y} values.}

\item{ypos.fixed}{numeric If not \code{NULL} used a constant value returned
in \code{y}.}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{na.rm}{a logical value indicating whether NA values should be stripped
before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\value{
A data frame with one row for each waveband object in the argument
to \code{w.band}. Wavebeand outside the range of the spectral data are
trimmed or discarded.
}
\description{
\code{stat_wb_irrad} computes areas under a curve.
}
\section{Computed variables}{

What it is named integral below is the result of appying \code{irrad},
\code{e_irrad} or \code{q_irrad} to the data.
\describe{
  \item{y.label}{yeff multiplied by \code{label.mult} and formatted
  according to \code{label.fmt}}
  \item{x}{w.band-midpoint}
  \item{wb.xmin}{w.band minimum}
  \item{wb.xmax}{w.band maximum}
  \item{wb.ymin}{data$y minimum}
  \item{wb.ymax}{data$y maximum}
  \item{wb.yeff}{weighted irradiance if \code{w.band} describes a BSWF}
  \item{wb.yint}{not weighted irradiance for the range of \code{w.band}}
  \item{wb.xmean}{yint divided by wl_expanse(w.band)}
  \item{y}{ypos.fixed or top of data, adjusted by \code{ypos.mult}}
  \item{wb.color}{color of the w.band}
  \item{wb.name}{label of w.band}
  \item{BW.color}{\code{black_or_white(wb.color)}}
}
}

\section{Default aesthetics}{

Set by the statistic and available to geoms.
\describe{
  \item{label}{..y.label..}
  \item{x}{..x..}
  \item{xmin}{..wb.xmin..}
  \item{xmax}{..wb.xmax..}
  \item{ymin}{..y.. - (..wb.ymax.. - ..wb.ymin..) * 0.03}
  \item{ymax}{..y.. + (..wb.ymax.. - ..wb.ymin..) * 0.03}
  \item{yintercept}{..wb.ymean..}
  \item{fill}{..wb.color..}
}
}

\section{Required aesthetics}{

Required by the statistic and need to be set with \code{aes()}.
\describe{
  \item{x}{numeric, wavelength in nanometres}
  \item{y}{numeric, a spectral quantity}
}
}

\examples{

library(photobiologyWavebands)
# ggplot() methods for spectral objects set a default mapping for x and y.

# using defaults for energy irradiance in W m-2
ggplot(sun.spct) +
  stat_wb_column(w.band = PAR(), alpha = 0.5) +
  stat_wb_e_irrad(w.band = PAR(), ypos.fixed = 0.32) +
  geom_line() +
  scale_fill_identity() + scale_color_identity()

# using defaults for photon irradiance in umol m-2 s-1
ggplot(sun.spct, unit.out = "photon") +
  stat_wb_column(w.band = PAR(), alpha = 0.5) +
  stat_wb_q_irrad(w.band = PAR(), ypos.fixed = 1.5e-6, label.mult = 1e6) +
  geom_line() +
  scale_fill_identity() + scale_color_identity()

# modify label format and position
ggplot(sun.spct) +
  stat_wb_column(w.band = VIS_bands(), alpha = 0.7) +
  stat_wb_e_irrad(w.band = VIS_bands(),
                  angle = 90, size = 3, hjust = "left",
                  label.fmt = "\%2.0f~~W~m^{-2}", parse = TRUE,
                  ypos.fixed = 0.1) +
  geom_line() +
  scale_fill_identity() + scale_color_identity()

# Changing label mapping
ggplot(sun.spct) +
  stat_wb_column(w.band = VIS_bands(), alpha = 0.5) +
  stat_wb_e_irrad(w.band = VIS_bands(),
               label.fmt = "\%.2f",
               angle = 90, color = "black", ypos.fixed = 0.1,
               hjust = "left", size = 3,
               mapping = aes(label = after_stat(paste(wb.name, ": ",
                                                signif(wb.yint, 3),
                                                sep = "")))) +
  geom_line() +
  scale_fill_identity() + scale_color_identity() +
  theme_bw()

}
\seealso{
Other stats functions: 
\code{\link{stat_color}()},
\code{\link{stat_find_qtys}()},
\code{\link{stat_find_wls}()},
\code{\link{stat_label_peaks}()},
\code{\link{stat_peaks}()},
\code{\link{stat_spikes}()},
\code{\link{stat_wb_box}()},
\code{\link{stat_wb_column}()},
\code{\link{stat_wb_contribution}()},
\code{\link{stat_wb_hbar}()},
\code{\link{stat_wb_label}()},
\code{\link{stat_wb_mean}()},
\code{\link{stat_wb_relative}()},
\code{\link{stat_wb_sirrad}()},
\code{\link{stat_wb_total}()},
\code{\link{stat_wl_strip}()},
\code{\link{stat_wl_summary}()}
}
\concept{stats functions}
