% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-wl-strip.R
\name{stat_wl_strip}
\alias{stat_wl_strip}
\alias{wl_guide}
\title{Calculate colours from wavelength.}
\usage{
stat_wl_strip(mapping = NULL, data = NULL, geom = "rect", type = "CMF",
  w.band = NULL, length.out = 150, position = "identity", na.rm = FALSE,
  show.legend = FALSE, inherit.aes = TRUE, ...)

wl_guide(mapping = NULL, data = NULL, type = "CMF", w.band = NULL,
  length.out = 150, ymin = -Inf, ymax = Inf, position = "identity",
  na.rm = FALSE, show.legend = FALSE, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_string}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{type}{character one of "CMF" (color matching function) or "CC"
(color coordinates).}

\item{w.band}{waveband object or a list of such objects or NULL.}

\item{length.out}{The number of steps to use to simulate a continuous
range of colours when w.band == NULL.}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{na.rm}{a logical value indicating whether NA values should be
stripped before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This can
include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{ymin, ymax}{numeric used as aesthetics for plotting the guide.}
}
\value{
generic_spect object with new \code{x} values plus other computed
  variables described below.
}
\description{
\code{stat_wl_strip} computes color definitions according to human vision.
}
\section{Computed variables}{

\describe{
   \item{x}{(w.low + wl.high) / 2}
   \item{wl.low}{boundary of waveband}
   \item{wl.high}{boundary of waveband}
   \item{wl.color}{color corresponding to wavelength}
   \item{wb.color}{color corresponding to waveband}
   \item{wb.name}{label of w.band}
}
}

\section{Default aesthetics}{

Set by the statistic and available to geoms.
\describe{
  \item{x}{..x..}
  \item{label}{as.character(..wb.f..)}
  \item{xmin}{..wl.low..}
  \item{xmax}{..wl.high..}
  \item{fill}{..wb.color..}
}
}

\section{Required aesthetics}{

Required by the statistic and need to be set with \code{aes()}.
\describe{
  \item{x}{numeric, wavelength in nanometres}
}
}
\examples{
library(photobiology)
library(ggplot2)
# ggplot() methods for spectral objects set a default mapping for x and y.
ggplot(sun.spct) + geom_line() +
  stat_wl_strip(ymax = -0.02, ymin = -0.04) +
  scale_fill_identity()

# on some graphic devices the output may show spurious vertical lines
ggplot(sun.spct) + wl_guide(alpha = 0.33, color = NA) + geom_line()

}
\seealso{
\code{\link[photobiology]{color}}, which is used internally.

Other stats functions: \code{\link{stat_color}},
  \code{\link{stat_label_peaks}}, \code{\link{stat_peaks}},
  \code{\link{stat_wb_box}}, \code{\link{stat_wb_column}},
  \code{\link{stat_wb_contribution}},
  \code{\link{stat_wb_hbar}}, \code{\link{stat_wb_irrad}},
  \code{\link{stat_wb_label}}, \code{\link{stat_wb_mean}},
  \code{\link{stat_wb_relative}},
  \code{\link{stat_wb_sirrad}},
  \code{\link{stat_wb_total}},
  \code{\link{stat_wl_summary}}
}

