% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproduce_metadata.R
\name{reproduce_sem}
\alias{reproduce_sem}
\title{Reproduce a SEM (Structural Equation Modeling) visualization from metadata}
\usage{
reproduce_sem(
  metadata = NULL,
  lavaan_syntax = NULL,
  group_id = NULL,
  object = NULL,
  zoom_level = 1.2
)
}
\arguments{
\item{metadata}{Either a metadata object or a file path to an RDS file
containing metadata captured from the Shiny app. If NULL, the function
will stop with an error.}

\item{lavaan_syntax}{Optional lavaan syntax string. If NULL, uses the
syntax stored in the metadata.}

\item{group_id}{The identifier for the specific SEM group to reproduce.
This corresponds to the group ID used in the original Shiny app.}

\item{object}{Optional SEM object to use instead of the one stored
in metadata. Useful for testing with different SEM objects.}

\item{zoom_level}{Zoom factor for the visualization. Default is 1.2.}
}
\value{
A ggplot object containing the reproduced SEM path diagram.
}
\description{
This function recreates a SEM path diagram using stored metadata from
a Shiny app session. It supports various SEM object types including
lavaan, semPlot, qgraph, and diagrammeR objects.
}
\examples{
\dontrun{
# Reproduce SEM from saved metadata
sem_plot <- reproduce_sem(
  metadata = "path/to/metadata.rds",
  group_id = "sem1"
)

# Reproduce with custom lavaan syntax
sem_plot <- reproduce_sem(
  metadata = metadata_object,
  lavaan_syntax = "y ~ x1 + x2",
  group_id = "sem1"
)
}

}
