% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_dendrogram.R
\name{den_to_igraph}
\alias{den_to_igraph}
\title{Convert a dendrogram into an igraph object}
\usage{
den_to_igraph(den, even = FALSE, ...)
}
\arguments{
\item{den}{A dendrogram object}

\item{even}{Logical should the position information be calculated based on an
even layout (see \code{\link{layout_dendrogram_even}}).}

\item{...}{Additional parameters to pass off to
\code{\link{layout_dendrogram_dendrogram}}}
}
\value{
An igraph object.
}
\description{
This small helper function converts a dendrogram into an igraph object with
the same node indexes as would be had were the dendrogram used directly in
a ggraph plot. The nodes would have the same attributes as would have been
calculated had the dendrogram been used in layout creation, meaning that e.g.
it contains a leaf attribute which is \code{TRUE} for leaf nodes and
\code{FALSE} for the rest.
}
