% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-dens2d-labels.r
\name{stat_dens2d_labels}
\alias{stat_dens2d_labels}
\title{Reset labels of observations in high density regions}
\usage{
stat_dens2d_labels(mapping = NULL, data = NULL, geom = "text",
  position = "identity", keep.fraction = 0.1, keep.number = Inf,
  h = NULL, n = NULL, label.fill = "", na.rm = TRUE,
  show.legend = FALSE, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data.}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{keep.fraction}{numeric [0..1].}

\item{keep.number}{integer number of labels to keep.}

\item{h}{vector of bandwidths for x and y directions. Defaults to normal
reference bandwidth (see bandwidth.nrd). A scalar value will be taken to
apply to both directions.}

\item{n}{Number of grid points in each direction. Can be scalar or a length-2
integer vector}

\item{label.fill}{character.}

\item{na.rm}{a logical value indicating whether NA values should be stripped
before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\description{
\code{stat_low_dens} Sets values ampped to \code{label} to
  \code{""} in regions of a plot panel with high density of observations.
}
\details{
\code{stat_dens2d_labels()} is designed to work together with
  statistics from package 'ggrepel'.  To avoid text labels being plotted over
  unlabelled points the corresponding rows in data need to be retained but
  labels replaced with the empty character string, \code{""}.
  \code{stat_dens2d_labels()} replaces labels by  \code{""} based on the
  local density of observations.
}
\section{Computed variables}{
 \describe{ \item{labels}{x at centre of range} }
}

\examples{

library(ggrepel)
library(gginnards)

random_string <- function(len = 6) {
paste(sample(letters, len, replace = TRUE), collapse = "")
}

# Make random data.
set.seed(1001)
d <- tibble::tibble(
  x = rnorm(100),
  y = rnorm(100),
  group = rep(c("A", "B"), c(50, 50)),
  lab = replicate(100, { random_string() })
)

ggplot(data = d, aes(x, y, label = lab)) +
  geom_point() +
  stat_dens2d_labels()

# Using geom_debug() we can see that all 100 rows in \\code{d} are
# returned. But only those labelled in the previous example still contain
# the original labels.
ggplot(data = d, aes(x, y, label = lab)) +
  geom_point() +
  stat_dens2d_labels(geom = "debug")

ggplot(data = d, aes(x, y, label = lab, color = group)) +
  geom_point() +
  stat_dens2d_labels()

ggplot(data = d, aes(x, y, label = lab, color = group)) +
  geom_point() +
  stat_dens2d_labels(geom = "text_repel")

ggplot(data = d, aes(x, y, label = lab, color = group)) +
  geom_point() +
  stat_dens2d_labels(geom = "text_repel", label.fill = NA)

}
\seealso{
\code{\link[MASS]{kde2d}} used internally.

Other statistics for selection of observations based on local density: \code{\link{stat_dens2d_filter}}
}
\concept{statistics for selection of observations based on local density}
