% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcCoordinates.R
\name{calculateCoordinates}
\alias{calculateCoordinates}
\title{Calculate coordinates for plotting individuals in a pedigree}
\usage{
calculateCoordinates(
  ped,
  personID = "personID",
  momID = "momID",
  dadID = "dadID",
  spouseID = "spouseID",
  sexVar = "sex",
  twinID = "twinID",
  code_male = NULL,
  config = list()
)
}
\arguments{
\item{ped}{A data frame containing the pedigree data. Needs personID, momID, and dadID columns}

\item{personID}{Character string specifying the column name for individual IDs.}

\item{momID}{Character string specifying the column name for mother IDs. Defaults to "momID".}

\item{dadID}{Character string specifying the column name for father IDs. Defaults to "dadID".}

\item{spouseID}{Character. Name of the column in `ped` for the spouse ID variable.}

\item{sexVar}{Character. Name of the column in `ped` for the sex variable.}

\item{twinID}{Character string specifying the column name for twin IDs. Defaults to "twinID".}

\item{code_male}{Value used to indicate male sex. Defaults to NULL.}

\item{config}{List of configuration options:
\describe{
  \item{code_male}{Default is 1. Used by BGmisc::recodeSex().}
  \item{ped_packed}{Logical, default TRUE. Passed to `kinship2::align.pedigree`.}
  \item{ped_align}{Logical, default TRUE. Align generations.}
  \item{ped_width}{Numeric, default 15. Controls spacing.}
}}
}
\value{
A data frame with one or more rows per person, each containing:
  \itemize{
    \item `x_order`, `y_order`: Grid indices representing layout rows and columns.
    \item `x_pos`, `y_pos`: Continuous coordinate positions used for plotting.
    \item `nid`: Internal numeric identifier for layout mapping.
    \item `extra`: Logical flag indicating whether this row is a secondary appearance.
  }
}
\description{
Extracts and modifies the x and y positions for each individual in a
pedigree data frame using the align.pedigree function from the `kinship2` package.
It returns a data.frame with positions for plotting.
}
