% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_rope}
\alias{ggml_rope}
\title{Rotary Position Embedding (Graph)}
\usage{
ggml_rope(ctx, a, b, n_dims, mode = 0L)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor of shape [head_dim, n_head, seq_len, batch]}

\item{b}{Position tensor (int32) of shape [seq_len] containing position indices}

\item{n_dims}{Number of dimensions to apply rotation to (usually head_dim)}

\item{mode}{RoPE mode: GGML_ROPE_TYPE_NORM (0), GGML_ROPE_TYPE_NEOX (2), etc.}
}
\value{
Tensor with same shape as input, with rotary embeddings applied
}
\description{
Creates a graph node for RoPE (Rotary Position Embedding).
RoPE is the dominant position encoding method in modern LLMs like LLaMA,
Mistral, and many others.
}
\details{
RoPE encodes position information by rotating pairs of dimensions in the
embedding space. The rotation angle depends on position and dimension index.

Key benefits of RoPE:
- Relative position information emerges naturally from rotation
- Better extrapolation to longer sequences than absolute embeddings
- No additional parameters needed
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
# Query tensor: head_dim=8, n_head=4, seq_len=16, batch=1
q <- ggml_new_tensor_4d(ctx, GGML_TYPE_F32, 8, 4, 16, 1)
ggml_set_f32(q, rnorm(8 * 4 * 16))
# Position indices
pos <- ggml_new_tensor_1d(ctx, GGML_TYPE_I32, 16)
ggml_set_i32(pos, 0:15)
# Apply RoPE
q_rope <- ggml_rope(ctx, q, pos, 8, GGML_ROPE_TYPE_NORM)
graph <- ggml_build_forward_expand(ctx, q_rope)
ggml_graph_compute(ctx, graph)
ggml_free(ctx)
}
}
