% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{admixed}
\alias{admixed}
\title{Simulated Dataset with 1D Geography}
\format{An object of class \code{list} of length 21.}
\usage{
admixed
}
\value{
A list with the following elements \describe{\item{ytrain}{simulated
  response vector for training set} \item{ytune}{simulated response vector
  for tuning parameter selection set} \item{ytest}{simulated response vector
  for test set} \item{xtrain}{simulated design matrix for training
  set}\item{xtune}{simulated design matrix for tuning parameter selection
  set}\item{xtest}{simulated design matrix for testing set}
  \item{xtrain_lasso}{simulated design matrix for training set for lasso
  model. This is the same as xtrain, but also includes the nPC principal
  components} \item{xtune_lasso}{simulated design matrix for tuning parameter
  selection set for lasso model. This is the same as xtune, but also includes
  the nPC principal components}\item{xtest}{simulated design matrix for
  testing set for lasso model. This is the same as xtest, but also includes
  the nPC principal components} \item{causal}{character vector of the names
  of the causal SNPs} \item{beta}{the vector of true regression coefficients}
  \item{kin_train}{2 times the estimated kinship for the training set
  individuals} \item{kin_tune_train}{The covariance matrix between the tuning
  set and the training set individuals} \item{kin_test_train}{The covariance
  matrix between the test set and training set individuals}
  \item{Xkinship}{the matrix of SNPs used to estimate the kinship matrix}
  \item{not_causal}{character vector of the non-causal SNPs} \item{PC}{the
  principal components for population structure adjustment} }
}
\description{
A simulated dataset to show the utility of this package
}
\details{
The code used to simulate the data is available at
  \url{https://github.com/sahirbhatnagar/ggmix/blob/master/data-raw/bnpsd-data.R}.
   See \code{\link{gen_structured_model}} for more details on the output and
  how the function used to simulate the data.
}
\examples{
data(admixed)
str(admixed)
}
\references{
Ochoa, Alejandro, and John D. Storey. 2016a. "FST And Kinship for
  Arbitrary Population Structures I: Generalized Definitions." bioRxiv
  doi:10.1101/083915.

Ochoa, Alejandro, and John D. Storey. 2016b. "FST And Kinship for
  Arbitrary Population Structures II: Method of Moments Estimators." bioRxiv
  doi:10.1101/083923.
}
\keyword{datasets}
